package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.node.identifier.tlv.NodeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv.Stateful;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Tlvs1} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Tlvs1
 */
public class Tlvs1Builder {

    private NodeIdentifier _nodeIdentifier;
    private Stateful _stateful;


    public Tlvs1Builder() {
    } 
    
    public Tlvs1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.NodeIdentifierTlv arg) {
        this._nodeIdentifier = arg.getNodeIdentifier();
    }
    
    public Tlvs1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.StatefulCapabilityTlv arg) {
        this._stateful = arg.getStateful();
    }

    public Tlvs1Builder(Tlvs1 base) {
        this._nodeIdentifier = base.getNodeIdentifier();
        this._stateful = base.getStateful();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.NodeIdentifierTlv</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.StatefulCapabilityTlv</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.NodeIdentifierTlv) {
            this._nodeIdentifier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.NodeIdentifierTlv)arg).getNodeIdentifier();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.StatefulCapabilityTlv) {
            this._stateful = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.StatefulCapabilityTlv)arg).getStateful();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.NodeIdentifierTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.StatefulCapabilityTlv] \n" +
              "but was: " + arg
            );
        }
    }

    public NodeIdentifier getNodeIdentifier() {
        return _nodeIdentifier;
    }
    
    public Stateful getStateful() {
        return _stateful;
    }

    public Tlvs1Builder setNodeIdentifier(NodeIdentifier value) {
        this._nodeIdentifier = value;
        return this;
    }
    
    public Tlvs1Builder setStateful(Stateful value) {
        this._stateful = value;
        return this;
    }

    public Tlvs1 build() {
        return new Tlvs1Impl(this);
    }

    private static final class Tlvs1Impl implements Tlvs1 {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Tlvs1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Tlvs1.class;
        }

        private final NodeIdentifier _nodeIdentifier;
        private final Stateful _stateful;


        private Tlvs1Impl(Tlvs1Builder base) {
            this._nodeIdentifier = base.getNodeIdentifier();
            this._stateful = base.getStateful();
        }

        @Override
        public NodeIdentifier getNodeIdentifier() {
            return _nodeIdentifier;
        }
        
        @Override
        public Stateful getStateful() {
            return _stateful;
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_nodeIdentifier == null) ? 0 : _nodeIdentifier.hashCode());
            result = prime * result + ((_stateful == null) ? 0 : _stateful.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Tlvs1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Tlvs1 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Tlvs1)obj;
            if (_nodeIdentifier == null) {
                if (other.getNodeIdentifier() != null) {
                    return false;
                }
            } else if(!_nodeIdentifier.equals(other.getNodeIdentifier())) {
                return false;
            }
            if (_stateful == null) {
                if (other.getStateful() != null) {
                    return false;
                }
            } else if(!_stateful.equals(other.getStateful())) {
                return false;
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Tlvs1 [");
            boolean first = true;
        
            if (_nodeIdentifier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nodeIdentifier=");
                builder.append(_nodeIdentifier);
             }
            if (_stateful != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_stateful=");
                builder.append(_stateful);
             }
            return builder.append(']').toString();
        }
    }

}
