package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.PlspId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>odl-pcep-ietf-stateful02</b>
 * <br />(Source path: <i>META-INF/yang/odl-pcep-ietf-stateful02.yang</i>):
 * <pre>
 * container lsp {
 *     leaf processing-rule {
 *         type boolean;
 *     }
 *     leaf ignore {
 *         type boolean;
 *     }
 *     container tlvs {
 *         container symbolic-path-name {
 *             leaf path-name {
 *                 type symbolic-path-name;
 *             }
 *             uses tlv;
 *         }
 *         container rsvp-error-spec {
 *             container rsvp-error {
 *                 leaf node {
 *                     type ip-address;
 *                 }
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 leaf code {
 *                     type uint8;
 *                 }
 *                 leaf value {
 *                     type uint16;
 *                 }
 *                 uses error-spec;
 *             }
 *             uses tlv;
 *         }
 *         container lsp-db-version {
 *             leaf version {
 *                 type uint64;
 *             }
 *             uses tlv;
 *         }
 *         list vendor-information-tlv {
 *             key     leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         uses rsvp-error-spec-tlv;
 *         uses vendor-information-tlvs;
 *         uses symbolic-path-name-tlv;
 *         uses lsp-db-version-tlv;
 *     }
 *     leaf plsp-id {
 *         type plsp-id;
 *     }
 *     leaf delegate {
 *         type boolean;
 *     }
 *     leaf sync {
 *         type boolean;
 *     }
 *     leaf remove {
 *         type boolean;
 *     }
 *     leaf operational {
 *         type boolean;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>odl-pcep-ietf-stateful02/lsp-object/lsp</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.LspBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.LspBuilder
 */
public interface Lsp
    extends
    ChildOf<LspObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:crabbe:stateful:02","2014-01-10","lsp");;

    Tlvs getTlvs();
    
    PlspId getPlspId();
    
    java.lang.Boolean isDelegate();
    
    java.lang.Boolean isSync();
    
    java.lang.Boolean isRemove();
    
    java.lang.Boolean isOperational();

}

