package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.PlspId;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp
 */
public class LspBuilder {

    private PlspId _plspId;
    private static List<Range<BigInteger>> _plspId_range;
    private Tlvs _tlvs;
    private java.lang.Boolean _delegate;
    private java.lang.Boolean _ignore;
    private java.lang.Boolean _operational;
    private java.lang.Boolean _processingRule;
    private java.lang.Boolean _remove;
    private java.lang.Boolean _sync;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>> augmentation = new HashMap<>();

    public LspBuilder() {
    } 
    
    
    public LspBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LspBuilder(Lsp base) {
        this._plspId = base.getPlspId();
        this._tlvs = base.getTlvs();
        this._delegate = base.isDelegate();
        this._ignore = base.isIgnore();
        this._operational = base.isOperational();
        this._processingRule = base.isProcessingRule();
        this._remove = base.isRemove();
        this._sync = base.isSync();
        if (base instanceof LspImpl) {
            LspImpl _impl = (LspImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader) {
            this._processingRule = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isProcessingRule();
            this._ignore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \n" +
              "but was: " + arg
            );
        }
    }

    public PlspId getPlspId() {
        return _plspId;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }
    
    public java.lang.Boolean isDelegate() {
        return _delegate;
    }
    
    public java.lang.Boolean isIgnore() {
        return _ignore;
    }
    
    public java.lang.Boolean isOperational() {
        return _operational;
    }
    
    public java.lang.Boolean isProcessingRule() {
        return _processingRule;
    }
    
    public java.lang.Boolean isRemove() {
        return _remove;
    }
    
    public java.lang.Boolean isSync() {
        return _sync;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public LspBuilder setPlspId(PlspId value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : _plspId_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _plspId_range));
            }
        }
        this._plspId = value;
        return this;
    }
    public static List<Range<BigInteger>> _plspId_range() {
        if (_plspId_range == null) {
            synchronized (LspBuilder.class) {
                if (_plspId_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(1048576L)));
                    _plspId_range = builder.build();
                }
            }
        }
        return _plspId_range;
    }
    
    public LspBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    public LspBuilder setDelegate(java.lang.Boolean value) {
        this._delegate = value;
        return this;
    }
    
    public LspBuilder setIgnore(java.lang.Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public LspBuilder setOperational(java.lang.Boolean value) {
        this._operational = value;
        return this;
    }
    
    public LspBuilder setProcessingRule(java.lang.Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public LspBuilder setRemove(java.lang.Boolean value) {
        this._remove = value;
        return this;
    }
    
    public LspBuilder setSync(java.lang.Boolean value) {
        this._sync = value;
        return this;
    }
    
    public LspBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Lsp build() {
        return new LspImpl(this);
    }

    private static final class LspImpl implements Lsp {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp.class;
        }

        private final PlspId _plspId;
        private final Tlvs _tlvs;
        private final java.lang.Boolean _delegate;
        private final java.lang.Boolean _ignore;
        private final java.lang.Boolean _operational;
        private final java.lang.Boolean _processingRule;
        private final java.lang.Boolean _remove;
        private final java.lang.Boolean _sync;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>> augmentation = new HashMap<>();

        private LspImpl(LspBuilder base) {
            this._plspId = base.getPlspId();
            this._tlvs = base.getTlvs();
            this._delegate = base.isDelegate();
            this._ignore = base.isIgnore();
            this._operational = base.isOperational();
            this._processingRule = base.isProcessingRule();
            this._remove = base.isRemove();
            this._sync = base.isSync();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public PlspId getPlspId() {
            return _plspId;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
        
        @Override
        public java.lang.Boolean isDelegate() {
            return _delegate;
        }
        
        @Override
        public java.lang.Boolean isIgnore() {
            return _ignore;
        }
        
        @Override
        public java.lang.Boolean isOperational() {
            return _operational;
        }
        
        @Override
        public java.lang.Boolean isProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public java.lang.Boolean isRemove() {
            return _remove;
        }
        
        @Override
        public java.lang.Boolean isSync() {
            return _sync;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_plspId == null) ? 0 : _plspId.hashCode());
            result = prime * result + ((_tlvs == null) ? 0 : _tlvs.hashCode());
            result = prime * result + ((_delegate == null) ? 0 : _delegate.hashCode());
            result = prime * result + ((_ignore == null) ? 0 : _ignore.hashCode());
            result = prime * result + ((_operational == null) ? 0 : _operational.hashCode());
            result = prime * result + ((_processingRule == null) ? 0 : _processingRule.hashCode());
            result = prime * result + ((_remove == null) ? 0 : _remove.hashCode());
            result = prime * result + ((_sync == null) ? 0 : _sync.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp)obj;
            if (_plspId == null) {
                if (other.getPlspId() != null) {
                    return false;
                }
            } else if(!_plspId.equals(other.getPlspId())) {
                return false;
            }
            if (_tlvs == null) {
                if (other.getTlvs() != null) {
                    return false;
                }
            } else if(!_tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (_delegate == null) {
                if (other.isDelegate() != null) {
                    return false;
                }
            } else if(!_delegate.equals(other.isDelegate())) {
                return false;
            }
            if (_ignore == null) {
                if (other.isIgnore() != null) {
                    return false;
                }
            } else if(!_ignore.equals(other.isIgnore())) {
                return false;
            }
            if (_operational == null) {
                if (other.isOperational() != null) {
                    return false;
                }
            } else if(!_operational.equals(other.isOperational())) {
                return false;
            }
            if (_processingRule == null) {
                if (other.isProcessingRule() != null) {
                    return false;
                }
            } else if(!_processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (_remove == null) {
                if (other.isRemove() != null) {
                    return false;
                }
            } else if(!_remove.equals(other.isRemove())) {
                return false;
            }
            if (_sync == null) {
                if (other.isSync() != null) {
                    return false;
                }
            } else if(!_sync.equals(other.isSync())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                LspImpl otherImpl = (LspImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Lsp [");
            boolean first = true;
        
            if (_plspId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_plspId=");
                builder.append(_plspId);
             }
            if (_tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(_tlvs);
             }
            if (_delegate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_delegate=");
                builder.append(_delegate);
             }
            if (_ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(_ignore);
             }
            if (_operational != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_operational=");
                builder.append(_operational);
             }
            if (_processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(_processingRule);
             }
            if (_remove != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_remove=");
                builder.append(_remove);
             }
            if (_sync != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sync=");
                builder.append(_sync);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
