package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.RsvpErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.symbolic.path.name.tlv.SymbolicPathName;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs
 */
public class TlvsBuilder {

    private LspDbVersion _lspDbVersion;
    private RsvpErrorSpec _rsvpErrorSpec;
    private SymbolicPathName _symbolicPathName;
    private List<VendorInformationTlv> _vendorInformationTlv;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>> augmentation = new HashMap<>();

    public TlvsBuilder() {
    } 
    
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.RsvpErrorSpecTlv arg) {
        this._rsvpErrorSpec = arg.getRsvpErrorSpec();
    }
    
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs arg) {
        this._vendorInformationTlv = arg.getVendorInformationTlv();
    }
    
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.SymbolicPathNameTlv arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
    }
    
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspDbVersionTlv arg) {
        this._lspDbVersion = arg.getLspDbVersion();
    }

    public TlvsBuilder(Tlvs base) {
        this._lspDbVersion = base.getLspDbVersion();
        this._rsvpErrorSpec = base.getRsvpErrorSpec();
        this._symbolicPathName = base.getSymbolicPathName();
        this._vendorInformationTlv = base.getVendorInformationTlv();
        if (base instanceof TlvsImpl) {
            TlvsImpl _impl = (TlvsImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.SymbolicPathNameTlv</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspDbVersionTlv</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.RsvpErrorSpecTlv</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs) {
            this._vendorInformationTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs)arg).getVendorInformationTlv();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.SymbolicPathNameTlv) {
            this._symbolicPathName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.SymbolicPathNameTlv)arg).getSymbolicPathName();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspDbVersionTlv) {
            this._lspDbVersion = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspDbVersionTlv)arg).getLspDbVersion();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.RsvpErrorSpecTlv) {
            this._rsvpErrorSpec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.RsvpErrorSpecTlv)arg).getRsvpErrorSpec();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.SymbolicPathNameTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspDbVersionTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.RsvpErrorSpecTlv] \n" +
              "but was: " + arg
            );
        }
    }

    public LspDbVersion getLspDbVersion() {
        return _lspDbVersion;
    }
    
    public RsvpErrorSpec getRsvpErrorSpec() {
        return _rsvpErrorSpec;
    }
    
    public SymbolicPathName getSymbolicPathName() {
        return _symbolicPathName;
    }
    
    public List<VendorInformationTlv> getVendorInformationTlv() {
        return _vendorInformationTlv;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public TlvsBuilder setLspDbVersion(LspDbVersion value) {
        this._lspDbVersion = value;
        return this;
    }
    
    public TlvsBuilder setRsvpErrorSpec(RsvpErrorSpec value) {
        this._rsvpErrorSpec = value;
        return this;
    }
    
    public TlvsBuilder setSymbolicPathName(SymbolicPathName value) {
        this._symbolicPathName = value;
        return this;
    }
    
    public TlvsBuilder setVendorInformationTlv(List<VendorInformationTlv> value) {
        this._vendorInformationTlv = value;
        return this;
    }
    
    public TlvsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class TlvsImpl implements Tlvs {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs.class;
        }

        private final LspDbVersion _lspDbVersion;
        private final RsvpErrorSpec _rsvpErrorSpec;
        private final SymbolicPathName _symbolicPathName;
        private final List<VendorInformationTlv> _vendorInformationTlv;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>> augmentation = new HashMap<>();

        private TlvsImpl(TlvsBuilder base) {
            this._lspDbVersion = base.getLspDbVersion();
            this._rsvpErrorSpec = base.getRsvpErrorSpec();
            this._symbolicPathName = base.getSymbolicPathName();
            this._vendorInformationTlv = base.getVendorInformationTlv();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public LspDbVersion getLspDbVersion() {
            return _lspDbVersion;
        }
        
        @Override
        public RsvpErrorSpec getRsvpErrorSpec() {
            return _rsvpErrorSpec;
        }
        
        @Override
        public SymbolicPathName getSymbolicPathName() {
            return _symbolicPathName;
        }
        
        @Override
        public List<VendorInformationTlv> getVendorInformationTlv() {
            return _vendorInformationTlv;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_lspDbVersion == null) ? 0 : _lspDbVersion.hashCode());
            result = prime * result + ((_rsvpErrorSpec == null) ? 0 : _rsvpErrorSpec.hashCode());
            result = prime * result + ((_symbolicPathName == null) ? 0 : _symbolicPathName.hashCode());
            result = prime * result + ((_vendorInformationTlv == null) ? 0 : _vendorInformationTlv.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs)obj;
            if (_lspDbVersion == null) {
                if (other.getLspDbVersion() != null) {
                    return false;
                }
            } else if(!_lspDbVersion.equals(other.getLspDbVersion())) {
                return false;
            }
            if (_rsvpErrorSpec == null) {
                if (other.getRsvpErrorSpec() != null) {
                    return false;
                }
            } else if(!_rsvpErrorSpec.equals(other.getRsvpErrorSpec())) {
                return false;
            }
            if (_symbolicPathName == null) {
                if (other.getSymbolicPathName() != null) {
                    return false;
                }
            } else if(!_symbolicPathName.equals(other.getSymbolicPathName())) {
                return false;
            }
            if (_vendorInformationTlv == null) {
                if (other.getVendorInformationTlv() != null) {
                    return false;
                }
            } else if(!_vendorInformationTlv.equals(other.getVendorInformationTlv())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TlvsImpl otherImpl = (TlvsImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Tlvs [");
            boolean first = true;
        
            if (_lspDbVersion != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lspDbVersion=");
                builder.append(_lspDbVersion);
             }
            if (_rsvpErrorSpec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rsvpErrorSpec=");
                builder.append(_rsvpErrorSpec);
             }
            if (_symbolicPathName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_symbolicPathName=");
                builder.append(_symbolicPathName);
             }
            if (_vendorInformationTlv != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vendorInformationTlv=");
                builder.append(_vendorInformationTlv);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
