/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.pcep.stateful02.cfg;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.pcep.stateful02.cfg.AbstractStateful02PCEPSessionProposalFactoryModule;
import org.opendaylight.protocol.pcep.PCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.ietf.stateful02.Stateful02SessionProposalFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class Stateful02PCEPSessionProposalFactoryModule
extends AbstractStateful02PCEPSessionProposalFactoryModule {
    private static final Logger LOG = LoggerFactory.getLogger(Stateful02PCEPSessionProposalFactoryModule.class);
    private static final String NOT_SET = "value is not set.";
    private static final int RATIO = 4;

    public Stateful02PCEPSessionProposalFactoryModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public Stateful02PCEPSessionProposalFactoryModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, Stateful02PCEPSessionProposalFactoryModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    protected void customValidation() {
        JmxAttributeValidationException.checkNotNull((Object)this.getActive(), (String)NOT_SET, (JmxAttribute)activeJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getInitiated(), (String)NOT_SET, (JmxAttribute)initiatedJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getDeadTimerValue(), (String)NOT_SET, (JmxAttribute)deadTimerValueJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getKeepAliveTimerValue(), (String)NOT_SET, (JmxAttribute)keepAliveTimerValueJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getTimeout(), (String)NOT_SET, (JmxAttribute)timeoutJmxAttribute);
        if (this.getKeepAliveTimerValue() != 0) {
            JmxAttributeValidationException.checkCondition((this.getKeepAliveTimerValue() >= 1 ? 1 : 0) != 0, (String)"minimum value is 1.", (JmxAttribute)keepAliveTimerValueJmxAttribute);
            if (this.getDeadTimerValue() != 0 && this.getDeadTimerValue() / this.getKeepAliveTimerValue() != 4) {
                LOG.warn("DeadTimerValue should be 4 times greater than KeepAliveTimerValue");
            }
        }
        if (this.getActive().booleanValue() && !this.getStateful().booleanValue()) {
            this.setStateful(true);
        }
        JmxAttributeValidationException.checkNotNull((Object)this.getStateful(), (String)NOT_SET, (JmxAttribute)statefulJmxAttribute);
    }

    public AutoCloseable createInstance() {
        Stateful02SessionProposalFactory inner = new Stateful02SessionProposalFactory(this.getDeadTimerValue().shortValue(), this.getKeepAliveTimerValue().shortValue(), this.getStateful(), this.getActive(), this.getInitiated(), this.getTimeout());
        return new PCEPSessionProposalFactoryCloseable(inner);
    }

    private static final class PCEPSessionProposalFactoryCloseable
    implements PCEPSessionProposalFactory,
    AutoCloseable {
        private final Stateful02SessionProposalFactory inner;

        public PCEPSessionProposalFactoryCloseable(Stateful02SessionProposalFactory inner) {
            this.inner = (Stateful02SessionProposalFactory)((Object)Preconditions.checkNotNull((Object)((Object)inner)));
        }

        @Override
        public void close() {
        }

        public Open getSessionProposal(InetSocketAddress inetSocketAddress, int sessionId) {
            return this.inner.getSessionProposal(inetSocketAddress, sessionId);
        }
    }
}

