/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.crabbe.initiated00;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.BitSet;
import org.opendaylight.protocol.pcep.ietf.stateful02.Stateful02StatefulCapabilityTlvParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.Stateful1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.Stateful1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv.Stateful;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv.StatefulBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;

@Deprecated
public final class PCEStatefulCapabilityTlvParser
extends Stateful02StatefulCapabilityTlvParser {
    private static final int I_FLAG_OFFSET = 29;

    @Override
    public Stateful parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        if (buffer.readableBytes() < 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >= " + 4 + ".");
        }
        BitSet flags = ByteArray.bytesToBitSet((byte[])ByteArray.readBytes((ByteBuf)buffer, (int)4));
        StatefulBuilder sb = new StatefulBuilder();
        sb.setIncludeDbVersion(flags.get(30));
        sb.setLspUpdateCapability(flags.get(31));
        if (flags.get(29)) {
            sb.addAugmentation(Stateful1.class, new Stateful1Builder().setInitiation(Boolean.TRUE).build());
        }
        return sb.build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof Stateful), (Object)"StatefulCapabilityTlv is mandatory.");
        Stateful sct = (Stateful)tlv;
        ByteBuf body = Unpooled.buffer();
        BitSet flags = new BitSet(32);
        Stateful1 sfi = (Stateful1)sct.getAugmentation(Stateful1.class);
        if (sfi != null) {
            flags.set(29, sfi.isInitiation());
        }
        if (sct.isLspUpdateCapability() != null) {
            flags.set(31, sct.isLspUpdateCapability());
        }
        if (sct.isIncludeDbVersion() != null) {
            flags.set(30, sct.isIncludeDbVersion());
        }
        ByteBufWriteUtil.writeBitSet((BitSet)flags, (int)4, (ByteBuf)body);
        TlvUtil.formatTlv((int)16, (ByteBuf)body, (ByteBuf)buffer);
    }
}

