/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.crabbe.initiated00;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.Pcinitiate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.PcinitiateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.pcinitiate.message.PcinitiateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.pcinitiate.message.PcinitiateMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.pcinitiate.message.pcinitiate.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.pcinitiate.message.pcinitiate.message.RequestsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;

@Deprecated
public class PcinitiateMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 12;

    public PcinitiateMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof Pcinitiate), (String)"Wrong instance of Message. Passed instance of %s. Need Pcinitiate.", (java.lang.Object[])new java.lang.Object[]{message.getClass()});
        PcinitiateMessage init = ((Pcinitiate)message).getPcinitiateMessage();
        ByteBuf buffer = Unpooled.buffer();
        for (Requests req : init.getRequests()) {
            this.serializeObject((Object)req.getEndpointsObj(), buffer);
            this.serializeObject((Object)req.getLspa(), buffer);
            this.serializeObject((Object)req.getEro(), buffer);
            this.serializeObject((Object)req.getBandwidth(), buffer);
            if (req.getMetrics() == null || req.getMetrics().isEmpty()) continue;
            for (Metrics m : req.getMetrics()) {
                this.serializeObject((Object)m.getMetric(), buffer);
            }
        }
        MessageUtil.formatMessage((int)12, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected Message validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        if (objects == null) {
            throw new IllegalArgumentException("Passed list can't be null.");
        }
        PcinitiateMessageBuilder builder = new PcinitiateMessageBuilder();
        ArrayList reqs = Lists.newArrayList();
        while (!objects.isEmpty()) {
            reqs.add(this.getValidRequest(objects));
        }
        builder.setRequests(reqs);
        return new PcinitiateBuilder().setPcinitiateMessage(builder.build()).build();
    }

    private Requests getValidRequest(List<Object> objects) {
        RequestsBuilder builder = new RequestsBuilder();
        builder.setEndpointsObj((EndpointsObj)objects.get(0));
        objects.remove(0);
        builder.setLspa((Lspa)objects.get(0));
        objects.remove(0);
        ArrayList metrics = Lists.newArrayList();
        State state = State.INIT;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.END)) {
            Object obj = objects.get(0);
            switch (state) {
                case INIT: {
                    state = State.ERO_IN;
                    if (obj instanceof Ero) {
                        builder.setEro((Ero)obj);
                        break;
                    }
                }
                case ERO_IN: {
                    state = State.BANDWIDTH_IN;
                    if (obj instanceof Bandwidth) {
                        builder.setBandwidth((Bandwidth)obj);
                        break;
                    }
                }
                case BANDWIDTH_IN: {
                    state = State.METRIC_IN;
                    if (obj instanceof Metric) {
                        metrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                        state = State.BANDWIDTH_IN;
                        break;
                    }
                }
                case METRIC_IN: {
                    state = State.END;
                    break;
                }
                case END: {
                    break;
                }
            }
            if (state.equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        builder.setMetrics(metrics);
        return builder.build();
    }

    private static enum State {
        INIT,
        ERO_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        END;

    }
}

