/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful02;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.BitSet;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.PlspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.LspBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.RsvpErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.symbolic.path.name.tlv.SymbolicPathName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;

@Deprecated
public class Stateful02LspObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    public static final int CLASS = 32;
    public static final int TYPE = 1;
    private static final int DELEGATE_FLAG_OFFSET = 15;
    private static final int SYNC_FLAG_OFFSET = 14;
    private static final int OPERATIONAL_FLAG_OFFSET = 13;
    private static final int REMOVE_FLAG_OFFSET = 12;
    private static final int ONE_B_OFFSET = 12;
    private static final int TWO_B_OFFSET = 4;
    private static final int FLAGS_SIZE = 2;

    public Stateful02LspObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    public Lsp parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        LspBuilder builder = new LspBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        int[] plspIdRaw = new int[]{bytes.readUnsignedByte(), bytes.readUnsignedByte(), bytes.getUnsignedByte(2)};
        builder.setPlspId(new PlspId(Long.valueOf(plspIdRaw[0] << 12 | plspIdRaw[1] << 4 | plspIdRaw[2] >> 4)));
        BitSet flags = ByteArray.bytesToBitSet((byte[])ByteArray.readBytes((ByteBuf)bytes, (int)2));
        builder.setDelegate(flags.get(15));
        builder.setSync(flags.get(14));
        builder.setRemove(flags.get(12));
        builder.setOperational(flags.get(13));
        TlvsBuilder b = new TlvsBuilder();
        this.parseTlvs(b, bytes.slice());
        builder.setTlvs(b.build());
        return builder.build();
    }

    public void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof RsvpErrorSpec) {
            builder.setRsvpErrorSpec((RsvpErrorSpec)tlv);
        } else if (tlv instanceof SymbolicPathName) {
            builder.setSymbolicPathName((SymbolicPathName)tlv);
        } else if (tlv instanceof LspDbVersion) {
            builder.setLspDbVersion((LspDbVersion)tlv);
        }
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Lsp), (String)"Wrong instance of PCEPObject. Passed %s. Needed LspObject.", (java.lang.Object[])new java.lang.Object[]{object.getClass()});
        Lsp specObj = (Lsp)object;
        ByteBuf body = Unpooled.buffer();
        PlspId plsp = specObj.getPlspId();
        Preconditions.checkArgument((plsp != null ? 1 : 0) != 0, (java.lang.Object)"PLSP-ID not present");
        ByteBufWriteUtil.writeMedium((Integer)(plsp.getValue().intValue() << 4), (ByteBuf)body);
        BitSet flags = new BitSet(16);
        if (specObj.isDelegate() != null) {
            flags.set(15, specObj.isDelegate());
        }
        if (specObj.isRemove() != null) {
            flags.set(12, specObj.isRemove());
        }
        if (specObj.isSync() != null) {
            flags.set(14, specObj.isSync());
        }
        if (specObj.isOperational() != null) {
            flags.set(13, specObj.isOperational());
        }
        body.writeByte((int)ByteArray.bitSetToBytes((BitSet)flags, (int)2)[1]);
        this.serializeTlvs(specObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)32, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getRsvpErrorSpec() != null) {
            this.serializeTlv(tlvs.getRsvpErrorSpec(), body);
        }
        if (tlvs.getSymbolicPathName() != null) {
            this.serializeTlv(tlvs.getSymbolicPathName(), body);
        }
        if (tlvs.getLspDbVersion() != null) {
            this.serializeTlv(tlvs.getLspDbVersion(), body);
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

