/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful02;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.impl.message.PCEPReplyMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.VendorInformationObjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Replies1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Replies1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcrep;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.PcrepMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.Replies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.RepliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.FailureCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.FailureCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.SuccessCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.SuccessCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.SuccessBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.PathsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yangtools.yang.binding.Augmentation;

@Deprecated
public final class Stateful02PCReplyMessageParser
extends PCEPReplyMessageParser {
    public Stateful02PCReplyMessageParser(ObjectRegistry registry, VendorInformationObjectRegistry viReg) {
        super(registry, viReg);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof Pcrep), (String)"Wrong instance of Message. Passed instance of %s. Need Pcrep.", (java.lang.Object[])new java.lang.Object[]{message.getClass()});
        PcrepMessage repMsg = ((Pcrep)message).getPcrepMessage();
        if (repMsg.getReplies() == null || repMsg.getReplies().isEmpty()) {
            throw new IllegalArgumentException("Replies cannot be null or empty.");
        }
        ByteBuf buffer = Unpooled.buffer();
        for (Replies reply : repMsg.getReplies()) {
            if (reply.getRp() == null) {
                throw new IllegalArgumentException("Reply must contain RP object.");
            }
            this.serializeObject((Object)reply.getRp(), buffer);
            if (reply.getAugmentation(Replies1.class) != null && ((Replies1)reply.getAugmentation(Replies1.class)).getLsp() != null) {
                this.serializeObject(((Replies1)reply.getAugmentation(Replies1.class)).getLsp(), buffer);
            }
            if (reply.getResult() == null) continue;
            if (reply.getResult() instanceof FailureCase) {
                FailureCase f = (FailureCase)reply.getResult();
                this.serializeObject((Object)f.getNoPath(), buffer);
                this.serializeObject((Object)f.getLspa(), buffer);
                this.serializeObject((Object)f.getBandwidth(), buffer);
                if (f.getMetrics() != null && !f.getMetrics().isEmpty()) {
                    for (Metrics m : f.getMetrics()) {
                        this.serializeObject((Object)m.getMetric(), buffer);
                    }
                }
                this.serializeObject((Object)f.getIro(), buffer);
                continue;
            }
            SuccessCase s = (SuccessCase)reply.getResult();
            for (Paths p : s.getSuccess().getPaths()) {
                this.serializeObject((Object)p.getEro(), buffer);
                this.serializeObject((Object)p.getLspa(), buffer);
                this.serializeObject((Object)p.getOf(), buffer);
                this.serializeObject((Object)p.getBandwidth(), buffer);
                if (p.getMetrics() != null && !p.getMetrics().isEmpty()) {
                    for (Metrics m : p.getMetrics()) {
                        this.serializeObject((Object)m.getMetric(), buffer);
                    }
                }
                this.serializeObject((Object)p.getIro(), buffer);
            }
        }
        MessageUtil.formatMessage((int)4, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected Replies getValidReply(List<Object> objects, List<Message> errors) {
        if (!(objects.get(0) instanceof Rp)) {
            errors.add(Stateful02PCReplyMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.RP_MISSING, (Optional)Optional.absent()));
            return null;
        }
        Rp rp = (Rp)objects.get(0);
        objects.remove(0);
        FailureCase res = null;
        Lsp lsp = null;
        if (objects.get(0) instanceof Lsp) {
            lsp = (Lsp)objects.get(0);
            objects.remove(0);
        }
        if (!objects.isEmpty()) {
            if (objects.get(0) instanceof NoPath) {
                NoPath noPath = (NoPath)objects.get(0);
                objects.remove(0);
                FailureCaseBuilder builder = new FailureCaseBuilder();
                builder.setNoPath(noPath);
                while (!objects.isEmpty()) {
                    this.parseAttributes(builder, objects);
                }
                res = builder.build();
            } else if (objects.get(0) instanceof Ero) {
                Ero ero = (Ero)objects.get(0);
                objects.remove(0);
                SuccessBuilder builder = new SuccessBuilder();
                ArrayList paths = Lists.newArrayList();
                PathsBuilder pBuilder = new PathsBuilder();
                pBuilder.setEro(ero);
                while (!objects.isEmpty()) {
                    this.parsePath(pBuilder, objects);
                    paths.add(pBuilder.build());
                }
                builder.setPaths((List)paths);
                res = new SuccessCaseBuilder().setSuccess(builder.build()).build();
            }
        }
        return new RepliesBuilder().setRp(rp).addAugmentation(Replies1.class, (Augmentation)new Replies1Builder().setLsp(lsp).build()).setResult(res).build();
    }
}

