/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful02;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Pcrpt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.PcrptBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcrpt.message.PcrptMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcrpt.message.pcrpt.message.Reports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcrpt.message.pcrpt.message.ReportsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcrpt.message.pcrpt.message.reports.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcrpt.message.pcrpt.message.reports.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;

@Deprecated
public final class Stateful02PCReportMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 10;

    public Stateful02PCReportMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof Pcrpt), (String)"Wrong instance of Message. Passed instance of %s. Need Pcrpt.", (java.lang.Object[])new java.lang.Object[]{message.getClass()});
        Pcrpt msg = (Pcrpt)message;
        List<Reports> reports = msg.getPcrptMessage().getReports();
        ByteBuf buffer = Unpooled.buffer();
        for (Reports report : reports) {
            this.serializeObject(report.getLsp(), buffer);
            Path p = report.getPath();
            if (p == null) continue;
            this.serializeObject((Object)p.getEro(), buffer);
            this.serializeObject((Object)p.getLspa(), buffer);
            this.serializeObject((Object)p.getBandwidth(), buffer);
            if (p.getMetrics() != null && !p.getMetrics().isEmpty()) {
                for (Metrics m : p.getMetrics()) {
                    this.serializeObject((Object)m.getMetric(), buffer);
                }
            }
            this.serializeObject((Object)p.getIro(), buffer);
        }
        MessageUtil.formatMessage((int)10, (ByteBuf)buffer, (ByteBuf)out);
    }

    public Message validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        if (objects == null) {
            throw new IllegalArgumentException("Passed list can't be null.");
        }
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcrpt message cannot be empty.");
        }
        ArrayList reports = Lists.newArrayList();
        while (!objects.isEmpty()) {
            Reports report = this.getValidReports(objects, errors);
            if (reports == null) continue;
            reports.add(report);
        }
        return new PcrptBuilder().setPcrptMessage(new PcrptMessageBuilder().setReports(reports).build()).build();
    }

    private Reports getValidReports(List<Object> objects, List<Message> errors) {
        ReportsBuilder builder = new ReportsBuilder();
        if (!(objects.get(0) instanceof Lsp)) {
            errors.add(Stateful02PCReportMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.LSP_MISSING, (Optional)Optional.absent()));
            return null;
        }
        builder.setLsp((Lsp)objects.get(0));
        objects.remove(0);
        if (!objects.isEmpty()) {
            PathBuilder pBuilder = new PathBuilder();
            this.parsePath(objects, pBuilder);
            builder.setPath(pBuilder.build());
        }
        return builder.build();
    }

    private void parsePath(List<Object> objects, PathBuilder builder) {
        ArrayList pathMetrics = Lists.newArrayList();
        State state = State.Init;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.End)) {
            Object obj = objects.get(0);
            switch (state) {
                case Init: {
                    state = State.EroIn;
                    if (obj instanceof Ero) {
                        builder.setEro((Ero)obj);
                        break;
                    }
                }
                case EroIn: {
                    state = State.LspaIn;
                    if (obj instanceof Lspa) {
                        builder.setLspa((Lspa)obj);
                        break;
                    }
                }
                case LspaIn: {
                    state = State.BandwidthIn;
                    if (obj instanceof Bandwidth) {
                        builder.setBandwidth((Bandwidth)obj);
                        break;
                    }
                }
                case BandwidthIn: {
                    state = State.MetricIn;
                    if (obj instanceof Metric) {
                        pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                        state = State.BandwidthIn;
                        break;
                    }
                }
                case MetricIn: {
                    state = State.IroIn;
                    if (obj instanceof Iro) {
                        builder.setIro((Iro)obj);
                        break;
                    }
                }
                case IroIn: {
                    state = State.End;
                    break;
                }
            }
            if (state.equals((java.lang.Object)State.End)) continue;
            objects.remove(0);
        }
        if (!pathMetrics.isEmpty()) {
            builder.setMetrics(pathMetrics);
        }
    }

    private static enum State {
        Init,
        EroIn,
        LspaIn,
        BandwidthIn,
        MetricIn,
        IroIn,
        End;

    }
}

