/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful02;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.impl.message.PCEPRequestMessageParser;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.VendorInformationObjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.P2p1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.P2p1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.SegmentComputationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2pBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRouteBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yangtools.yang.binding.Augmentation;

@Deprecated
public final class Stateful02PCRequestMessageParser
extends PCEPRequestMessageParser {
    public Stateful02PCRequestMessageParser(ObjectRegistry registry, VendorInformationObjectRegistry viReg) {
        super(registry, viReg);
    }

    protected void serializeP2P(ByteBuf buffer, P2p p2p) {
        ReportedRoute rr;
        this.serializeObject((Object)p2p.getEndpointsObj(), buffer);
        if (p2p.getAugmentation(P2p1.class) != null) {
            this.serializeObject(((P2p1)p2p.getAugmentation(P2p1.class)).getLsp(), buffer);
        }
        if ((rr = p2p.getReportedRoute()) != null) {
            this.serializeObject((Object)rr.getRro(), buffer);
            this.serializeObject((Object)rr.getBandwidth(), buffer);
        }
        this.serializeObject((Object)p2p.getLoadBalancing(), buffer);
        this.serializeObject((Object)p2p.getLspa(), buffer);
        this.serializeObject((Object)p2p.getBandwidth(), buffer);
        if (p2p.getMetrics() != null) {
            for (Metrics m : p2p.getMetrics()) {
                this.serializeObject((Object)m.getMetric(), buffer);
            }
        }
        this.serializeObject((Object)p2p.getIro(), buffer);
        this.serializeObject((Object)p2p.getRro(), buffer);
        this.serializeObject((Object)p2p.getXro(), buffer);
        this.serializeObject((Object)p2p.getOf(), buffer);
        this.serializeObject((Object)p2p.getClassType(), buffer);
    }

    protected SegmentComputation getSegmentComputation(P2pBuilder builder, List<Object> objects, List<Message> errors, Rp rp) {
        ArrayList metrics = Lists.newArrayList();
        State state = State.Init;
        while (!objects.isEmpty() && state != State.End) {
            Object obj = objects.get(0);
            switch (state) {
                case Init: {
                    state = State.LspIn;
                    if (obj instanceof Lsp) {
                        builder.addAugmentation(P2p1.class, (Augmentation)new P2p1Builder().setLsp((Lsp)obj).build());
                        break;
                    }
                }
                case LspIn: {
                    state = State.ReportedIn;
                    if (obj instanceof Rro) {
                        ReportedRouteBuilder rrBuilder = new ReportedRouteBuilder();
                        rrBuilder.setRro((Rro)obj);
                        objects.remove(0);
                        obj = objects.get(0);
                        if (!(obj instanceof Bandwidth)) break;
                        rrBuilder.setBandwidth((Bandwidth)obj);
                        break;
                    }
                }
                case ReportedIn: {
                    state = State.LoadBIn;
                    if (obj instanceof LoadBalancing) {
                        builder.setLoadBalancing((LoadBalancing)obj);
                        break;
                    }
                }
                case LoadBIn: {
                    state = State.LspaIn;
                    if (obj instanceof Lspa) {
                        builder.setLspa((Lspa)obj);
                        break;
                    }
                }
                case LspaIn: {
                    state = State.BandwidthIn;
                    if (obj instanceof Bandwidth) {
                        builder.setBandwidth((Bandwidth)obj);
                        break;
                    }
                }
                case BandwidthIn: {
                    state = State.MetricIn;
                    if (obj instanceof Metric) {
                        metrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                        state = State.BandwidthIn;
                        break;
                    }
                }
                case MetricIn: {
                    state = State.IroIn;
                    if (obj instanceof Iro) {
                        builder.setIro((Iro)obj);
                        break;
                    }
                }
                case IroIn: {
                    state = State.RroIn;
                    if (obj instanceof Rro) {
                        builder.setRro((Rro)obj);
                        break;
                    }
                }
                case RroIn: {
                    state = State.XroIn;
                    if (obj instanceof Xro) {
                        builder.setXro((Xro)obj);
                        break;
                    }
                }
                case XroIn: {
                    state = State.OfIn;
                    if (obj instanceof Of) {
                        builder.setOf((Of)obj);
                        break;
                    }
                }
                case OfIn: {
                    state = State.CtIn;
                    if (obj instanceof ClassType) {
                        ClassType classType = (ClassType)obj;
                        if (!classType.isProcessingRule().booleanValue()) {
                            errors.add(Stateful02PCRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.P_FLAG_NOT_SET, (Optional)Optional.of((java.lang.Object)rp)));
                            break;
                        }
                        builder.setClassType(classType);
                        break;
                    }
                }
                case CtIn: {
                    state = State.End;
                    break;
                }
            }
            if (state.equals((java.lang.Object)State.End)) continue;
            objects.remove(0);
        }
        if (!metrics.isEmpty()) {
            builder.setMetrics((List)metrics);
        }
        if (rp.isReoptimization().booleanValue() && builder.getBandwidth() != null && !builder.getReportedRoute().getBandwidth().getBandwidth().equals((java.lang.Object)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth(new byte[]{0})) && builder.getReportedRoute().getRro() == null) {
            errors.add(Stateful02PCRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.RRO_MISSING, (Optional)Optional.of((java.lang.Object)rp)));
            return null;
        }
        return new SegmentComputationBuilder().setP2p(builder.build()).build();
    }

    private static enum State {
        Init,
        LspIn,
        ReportedIn,
        LoadBIn,
        LspaIn,
        BandwidthIn,
        MetricIn,
        IroIn,
        RroIn,
        XroIn,
        OfIn,
        CtIn,
        End;

    }
}

