/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful02;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Pcupd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.PcupdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message.PcupdMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message.pcupd.message.Updates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message.pcupd.message.UpdatesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message.pcupd.message.updates.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message.pcupd.message.updates.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;

@Deprecated
public final class Stateful02PCUpdateRequestMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 11;

    public Stateful02PCUpdateRequestMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof Pcupd), (String)"Wrong instance of Message. Passed instance of %s. Need Pcupd.", (java.lang.Object[])new java.lang.Object[]{message.getClass()});
        Pcupd msg = (Pcupd)message;
        List<Updates> updates = msg.getPcupdMessage().getUpdates();
        ByteBuf buffer = Unpooled.buffer();
        for (Updates update : updates) {
            this.serializeObject(update.getLsp(), buffer);
            Path p = update.getPath();
            if (p == null) continue;
            this.serializeObject((Object)p.getEro(), buffer);
            this.serializeObject((Object)p.getLspa(), buffer);
            this.serializeObject((Object)p.getBandwidth(), buffer);
            if (p.getMetrics() != null && !p.getMetrics().isEmpty()) {
                for (Metrics m : p.getMetrics()) {
                    this.serializeObject((Object)m.getMetric(), buffer);
                }
            }
            this.serializeObject((Object)p.getIro(), buffer);
        }
        MessageUtil.formatMessage((int)11, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected Message validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        if (objects == null) {
            throw new IllegalArgumentException("Passed list can't be null.");
        }
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcup message cannot be empty.");
        }
        ArrayList updateRequests = Lists.newArrayList();
        while (!objects.isEmpty()) {
            Updates update = this.getValidUpdates(objects, errors);
            if (update == null) continue;
            updateRequests.add(update);
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new PcupdBuilder().setPcupdMessage(new PcupdMessageBuilder().setUpdates(updateRequests).build()).build();
    }

    private Updates getValidUpdates(List<Object> objects, List<Message> errors) {
        UpdatesBuilder builder = new UpdatesBuilder();
        if (!(objects.get(0) instanceof Lsp)) {
            errors.add(Stateful02PCUpdateRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.LSP_MISSING, (Optional)Optional.absent()));
            return null;
        }
        builder.setLsp((Lsp)objects.get(0));
        objects.remove(0);
        if (!objects.isEmpty()) {
            PathBuilder pBuilder = new PathBuilder();
            if (!(objects.get(0) instanceof Ero)) {
                errors.add(Stateful02PCUpdateRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.ERO_MISSING, (Optional)Optional.absent()));
                return null;
            }
            pBuilder.setEro((Ero)objects.get(0));
            objects.remove(0);
            this.parsePath(objects, pBuilder);
            builder.setPath(pBuilder.build());
        }
        return builder.build();
    }

    private void parsePath(List<Object> objects, PathBuilder pBuilder) {
        ArrayList pathMetrics = Lists.newArrayList();
        State state = State.Init;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.End)) {
            Object obj = objects.get(0);
            switch (state) {
                case Init: {
                    state = State.LspaIn;
                    if (obj instanceof Lspa) {
                        pBuilder.setLspa((Lspa)obj);
                        break;
                    }
                }
                case LspaIn: {
                    state = State.BandwidthIn;
                    if (obj instanceof Bandwidth) {
                        pBuilder.setBandwidth((Bandwidth)obj);
                        break;
                    }
                }
                case BandwidthIn: {
                    state = State.MetricIn;
                    if (obj instanceof Metric) {
                        pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                        state = State.BandwidthIn;
                        break;
                    }
                }
                case MetricIn: {
                    state = State.IroIn;
                    if (obj instanceof Iro) {
                        pBuilder.setIro((Iro)obj);
                        break;
                    }
                }
                case IroIn: {
                    state = State.End;
                    break;
                }
            }
            if (state.equals((java.lang.Object)State.End)) continue;
            objects.remove(0);
        }
        if (!pathMetrics.isEmpty()) {
            pBuilder.setMetrics(pathMetrics);
        }
    }

    private static enum State {
        Init,
        LspaIn,
        BandwidthIn,
        MetricIn,
        IroIn,
        End;

    }
}

