/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful02;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.BitSet;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.RsvpErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.RsvpErrorSpecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.rsvp.error.spec.RsvpError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.rsvp.error.spec.RsvpErrorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.ErrorSpec;

@Deprecated
public final class Stateful02RSVPErrorSpecTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 21;
    private static final int FLAGS_F_LENGTH = 1;
    private static final int IN_PLACE_FLAG_OFFSET = 7;
    private static final int NOT_GUILTY_FLAGS_OFFSET = 6;
    private static final int V4_RSVP_LENGTH = 8;
    private static final int V6_RSVP_LENGTH = 20;

    public RsvpErrorSpec parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        RsvpErrorBuilder builder = new RsvpErrorBuilder();
        if (buffer.readableBytes() == 8) {
            builder.setNode(new IpAddress(Ipv4Util.addressForByteBuf((ByteBuf)buffer)));
        } else if (buffer.readableBytes() == 20) {
            builder.setNode(new IpAddress(Ipv6Util.addressForByteBuf((ByteBuf)buffer)));
        }
        BitSet flags = ByteArray.bytesToBitSet((byte[])ByteArray.readBytes((ByteBuf)buffer, (int)1));
        builder.setFlags(new ErrorSpec.Flags(Boolean.valueOf(flags.get(7)), Boolean.valueOf(flags.get(6))));
        short errorCode = (short)UnsignedBytes.toInt((byte)buffer.readByte());
        builder.setCode(errorCode);
        int errorValue = buffer.readUnsignedShort();
        builder.setValue(errorValue);
        return new RsvpErrorSpecBuilder().setRsvpError(builder.build()).build();
    }

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        IpAddress node;
        Preconditions.checkArgument((boolean)(tlv instanceof RsvpErrorSpec), (Object)"RSVPErrorSpecTlv is mandatory.");
        RsvpErrorSpec rsvpTlv = (RsvpErrorSpec)tlv;
        RsvpError rsvp = rsvpTlv.getRsvpError();
        ByteBuf body = Unpooled.buffer();
        BitSet flags = new BitSet(8);
        ErrorSpec.Flags f = rsvp.getFlags();
        if (f.isInPlace() != null) {
            flags.set(7, f.isInPlace());
        }
        if (f.isNotGuilty() != null) {
            flags.set(6, f.isNotGuilty());
        }
        Preconditions.checkArgument(((node = rsvp.getNode()) != null ? 1 : 0) != 0, (Object)"Node is mandatory.");
        if (node.getIpv4Address() != null) {
            ByteBufWriteUtil.writeIpv4Address((Ipv4Address)node.getIpv4Address(), (ByteBuf)body);
        } else {
            ByteBufWriteUtil.writeIpv6Address((Ipv6Address)node.getIpv6Address(), (ByteBuf)body);
        }
        ByteBufWriteUtil.writeBitSet((BitSet)flags, (int)1, (ByteBuf)body);
        Preconditions.checkArgument((rsvp.getCode() != null ? 1 : 0) != 0, (Object)"Code is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte((Short)rsvp.getCode(), (ByteBuf)body);
        Preconditions.checkArgument((rsvp.getValue() != null ? 1 : 0) != 0, (Object)"Value is mandatory.");
        ByteBufWriteUtil.writeUnsignedShort((Integer)rsvp.getValue(), (ByteBuf)body);
        TlvUtil.formatTlv((int)21, (ByteBuf)body, (ByteBuf)buffer);
    }
}

