/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful02;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.BitSet;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv.Stateful;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv.StatefulBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;

@Deprecated
public class Stateful02StatefulCapabilityTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 16;
    protected static final int FLAGS_F_LENGTH = 4;
    protected static final int S_FLAG_OFFSET = 30;
    protected static final int U_FLAG_OFFSET = 31;

    public Stateful parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        if (buffer.readableBytes() < 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >= " + 4 + ".");
        }
        BitSet flags = ByteArray.bytesToBitSet((byte[])ByteArray.readBytes((ByteBuf)buffer, (int)4));
        StatefulBuilder sb = new StatefulBuilder();
        sb.setIncludeDbVersion(flags.get(30));
        sb.setLspUpdateCapability(flags.get(31));
        return sb.build();
    }

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof Stateful), (Object)"StatefulCapabilityTlv is mandatory.");
        Stateful sct = (Stateful)tlv;
        ByteBuf body = Unpooled.buffer();
        BitSet flags = new BitSet(32);
        if (sct.isLspUpdateCapability() != null) {
            flags.set(31, sct.isLspUpdateCapability());
        }
        if (sct.isIncludeDbVersion() != null) {
            flags.set(30, sct.isIncludeDbVersion());
        }
        ByteBufWriteUtil.writeBitSet((BitSet)flags, (int)4, (ByteBuf)body);
        TlvUtil.formatTlv((int)16, (ByteBuf)body, (ByteBuf)buffer);
    }
}

