/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.lsp.cleanup.tlv;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated._00.rev140113.lsp.cleanup.tlv.LspCleanup;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspCleanupBuilder
implements Builder<LspCleanup> {
    private Long _timeout;
    Map<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>> augmentation = Collections.emptyMap();

    public LspCleanupBuilder() {
    }

    public LspCleanupBuilder(LspCleanup base) {
        AugmentationHolder casted;
        this._timeout = base.getTimeout();
        if (base instanceof LspCleanupImpl) {
            LspCleanupImpl impl = (LspCleanupImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>>(casted.augmentations());
        }
    }

    public Long getTimeout() {
        return this._timeout;
    }

    public <E extends Augmentation<LspCleanup>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkTimeoutRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public LspCleanupBuilder setTimeout(Long value) {
        if (value != null) {
            LspCleanupBuilder.checkTimeoutRange(value);
        }
        this._timeout = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _timeout_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public LspCleanupBuilder addAugmentation(Class<? extends Augmentation<LspCleanup>> augmentationType, Augmentation<LspCleanup> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LspCleanupBuilder removeAugmentation(Class<? extends Augmentation<LspCleanup>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LspCleanup build() {
        return new LspCleanupImpl(this);
    }

    private static final class LspCleanupImpl
    implements LspCleanup {
        private final Long _timeout;
        private Map<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LspCleanup> getImplementedInterface() {
            return LspCleanup.class;
        }

        private LspCleanupImpl(LspCleanupBuilder base) {
            this._timeout = base.getTimeout();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getTimeout() {
            return this._timeout;
        }

        public <E extends Augmentation<LspCleanup>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._timeout == null ? 0 : this._timeout.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LspCleanup.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LspCleanup other = (LspCleanup)obj;
            if (this._timeout == null ? other.getTimeout() != null : !this._timeout.equals(other.getTimeout())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspCleanupImpl otherImpl = (LspCleanupImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LspCleanup>>, Augmentation<LspCleanup>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LspCleanup [");
            boolean first = true;
            if (this._timeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_timeout=");
                builder.append(this._timeout);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

