/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.io.BaseEncoding;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeIdentifier
implements Serializable {
    private static final long serialVersionUID = 2141999227154091276L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length >= 1 && length <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1\u202565535]].", Arrays.toString(value)));
    }

    @ConstructorProperties(value={"value"})
    public NodeIdentifier(byte[] _value) {
        if (_value != null) {
            NodeIdentifier.check_valueLength(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = (byte[])_value.clone();
    }

    public NodeIdentifier(NodeIdentifier source) {
        this._value = source._value;
    }

    public static NodeIdentifier getDefaultInstance(String defaultValue) {
        BaseEncoding baseEncoding = BaseEncoding.base64();
        return new NodeIdentifier(baseEncoding.decode((CharSequence)defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : Arrays.hashCode(this._value));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeIdentifier other = (NodeIdentifier)obj;
        return !(this._value == null ? other._value != null : !Arrays.equals(this._value, other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(NodeIdentifier.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(Arrays.toString(this._value));
        }
        return builder.append(']').toString();
    }

    @Deprecated
    public static List<Range<BigInteger>> length() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }
}

