/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.db.version.tlv;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspDbVersionBuilder
implements Builder<LspDbVersion> {
    private BigInteger _version;
    Map<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKVERSIONRANGE_RANGES;

    public LspDbVersionBuilder() {
    }

    public LspDbVersionBuilder(LspDbVersion base) {
        AugmentationHolder casted;
        this._version = base.getVersion();
        if (base instanceof LspDbVersionImpl) {
            LspDbVersionImpl impl = (LspDbVersionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>(casted.augmentations());
        }
    }

    public BigInteger getVersion() {
        return this._version;
    }

    public <E extends Augmentation<LspDbVersion>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkVersionRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKVERSIONRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKVERSIONRANGE_RANGES)));
    }

    public LspDbVersionBuilder setVersion(BigInteger value) {
        if (value != null) {
            LspDbVersionBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _version_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public LspDbVersionBuilder addAugmentation(Class<? extends Augmentation<LspDbVersion>> augmentationType, Augmentation<LspDbVersion> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LspDbVersionBuilder removeAugmentation(Class<? extends Augmentation<LspDbVersion>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LspDbVersion build() {
        return new LspDbVersionImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKVERSIONRANGE_RANGES = a;
    }

    private static final class LspDbVersionImpl
    implements LspDbVersion {
        private final BigInteger _version;
        private Map<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LspDbVersion> getImplementedInterface() {
            return LspDbVersion.class;
        }

        private LspDbVersionImpl(LspDbVersionBuilder base) {
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getVersion() {
            return this._version;
        }

        public <E extends Augmentation<LspDbVersion>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LspDbVersion.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LspDbVersion other = (LspDbVersion)obj;
            if (this._version == null ? other.getVersion() != null : !this._version.equals(other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspDbVersionImpl otherImpl = (LspDbVersionImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LspDbVersion [");
            boolean first = true;
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

