/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.PlspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspBuilder
implements Builder<Lsp> {
    private PlspId _plspId;
    private Tlvs _tlvs;
    private Boolean _delegate;
    private Boolean _ignore;
    private Boolean _operational;
    private Boolean _processingRule;
    private Boolean _remove;
    private Boolean _sync;
    Map<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> augmentation = Collections.emptyMap();

    public LspBuilder() {
    }

    public LspBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LspBuilder(Lsp base) {
        AugmentationHolder casted;
        this._plspId = base.getPlspId();
        this._tlvs = base.getTlvs();
        this._delegate = base.isDelegate();
        this._ignore = base.isIgnore();
        this._operational = base.isOperational();
        this._processingRule = base.isProcessingRule();
        this._remove = base.isRemove();
        this._sync = base.isSync();
        if (base instanceof LspImpl) {
            LspImpl impl = (LspImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public PlspId getPlspId() {
        return this._plspId;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isDelegate() {
        return this._delegate;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isOperational() {
        return this._operational;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isRemove() {
        return this._remove;
    }

    public Boolean isSync() {
        return this._sync;
    }

    public <E extends Augmentation<Lsp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPlspIdRange(long value) {
        if (value >= 0L && value <= 0x100000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20251048576]].", value));
    }

    public LspBuilder setPlspId(PlspId value) {
        if (value != null) {
            LspBuilder.checkPlspIdRange(value.getValue());
        }
        this._plspId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _plspId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0x100000L)));
        return ret;
    }

    public LspBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public LspBuilder setDelegate(Boolean value) {
        this._delegate = value;
        return this;
    }

    public LspBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LspBuilder setOperational(Boolean value) {
        this._operational = value;
        return this;
    }

    public LspBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LspBuilder setRemove(Boolean value) {
        this._remove = value;
        return this;
    }

    public LspBuilder setSync(Boolean value) {
        this._sync = value;
        return this;
    }

    public LspBuilder addAugmentation(Class<? extends Augmentation<Lsp>> augmentationType, Augmentation<Lsp> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LspBuilder removeAugmentation(Class<? extends Augmentation<Lsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Lsp build() {
        return new LspImpl(this);
    }

    private static final class LspImpl
    implements Lsp {
        private final PlspId _plspId;
        private final Tlvs _tlvs;
        private final Boolean _delegate;
        private final Boolean _ignore;
        private final Boolean _operational;
        private final Boolean _processingRule;
        private final Boolean _remove;
        private final Boolean _sync;
        private Map<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Lsp> getImplementedInterface() {
            return Lsp.class;
        }

        private LspImpl(LspBuilder base) {
            this._plspId = base.getPlspId();
            this._tlvs = base.getTlvs();
            this._delegate = base.isDelegate();
            this._ignore = base.isIgnore();
            this._operational = base.isOperational();
            this._processingRule = base.isProcessingRule();
            this._remove = base.isRemove();
            this._sync = base.isSync();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>>(base.augmentation);
                }
            }
        }

        @Override
        public PlspId getPlspId() {
            return this._plspId;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isDelegate() {
            return this._delegate;
        }

        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isOperational() {
            return this._operational;
        }

        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isRemove() {
            return this._remove;
        }

        @Override
        public Boolean isSync() {
            return this._sync;
        }

        public <E extends Augmentation<Lsp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._plspId == null ? 0 : this._plspId.hashCode());
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._delegate == null ? 0 : this._delegate.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._operational == null ? 0 : this._operational.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this._remove == null ? 0 : this._remove.hashCode());
            result = 31 * result + (this._sync == null ? 0 : this._sync.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Lsp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Lsp other = (Lsp)obj;
            if (this._plspId == null ? other.getPlspId() != null : !this._plspId.equals(other.getPlspId())) {
                return false;
            }
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._delegate == null ? other.isDelegate() != null : !this._delegate.equals(other.isDelegate())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._operational == null ? other.isOperational() != null : !this._operational.equals(other.isOperational())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this._remove == null ? other.isRemove() != null : !this._remove.equals(other.isRemove())) {
                return false;
            }
            if (this._sync == null ? other.isSync() != null : !this._sync.equals(other.isSync())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspImpl otherImpl = (LspImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Lsp [");
            boolean first = true;
            if (this._plspId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_plspId=");
                builder.append(this._plspId);
            }
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._delegate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_delegate=");
                builder.append(this._delegate);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._operational != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_operational=");
                builder.append(this._operational);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (this._remove != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_remove=");
                builder.append(this._remove);
            }
            if (this._sync != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sync=");
                builder.append(this._sync);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

