/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspDbVersionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.RsvpErrorSpecTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.SymbolicPathNameTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.RsvpErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.symbolic.path.name.tlv.SymbolicPathName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TlvsBuilder
implements Builder<Tlvs> {
    private LspDbVersion _lspDbVersion;
    private RsvpErrorSpec _rsvpErrorSpec;
    private SymbolicPathName _symbolicPathName;
    private List<VendorInformationTlv> _vendorInformationTlv;
    Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();

    public TlvsBuilder() {
    }

    public TlvsBuilder(RsvpErrorSpecTlv arg) {
        this._rsvpErrorSpec = arg.getRsvpErrorSpec();
    }

    public TlvsBuilder(VendorInformationTlvs arg) {
        this._vendorInformationTlv = arg.getVendorInformationTlv();
    }

    public TlvsBuilder(SymbolicPathNameTlv arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
    }

    public TlvsBuilder(LspDbVersionTlv arg) {
        this._lspDbVersion = arg.getLspDbVersion();
    }

    public TlvsBuilder(Tlvs base) {
        AugmentationHolder casted;
        this._lspDbVersion = base.getLspDbVersion();
        this._rsvpErrorSpec = base.getRsvpErrorSpec();
        this._symbolicPathName = base.getSymbolicPathName();
        this._vendorInformationTlv = base.getVendorInformationTlv();
        if (base instanceof TlvsImpl) {
            TlvsImpl impl = (TlvsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VendorInformationTlvs) {
            this._vendorInformationTlv = ((VendorInformationTlvs)arg).getVendorInformationTlv();
            isValidArg = true;
        }
        if (arg instanceof SymbolicPathNameTlv) {
            this._symbolicPathName = ((SymbolicPathNameTlv)arg).getSymbolicPathName();
            isValidArg = true;
        }
        if (arg instanceof LspDbVersionTlv) {
            this._lspDbVersion = ((LspDbVersionTlv)arg).getLspDbVersion();
            isValidArg = true;
        }
        if (arg instanceof RsvpErrorSpecTlv) {
            this._rsvpErrorSpec = ((RsvpErrorSpecTlv)arg).getRsvpErrorSpec();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.SymbolicPathNameTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.LspDbVersionTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.RsvpErrorSpecTlv] \nbut was: " + arg);
        }
    }

    public LspDbVersion getLspDbVersion() {
        return this._lspDbVersion;
    }

    public RsvpErrorSpec getRsvpErrorSpec() {
        return this._rsvpErrorSpec;
    }

    public SymbolicPathName getSymbolicPathName() {
        return this._symbolicPathName;
    }

    public List<VendorInformationTlv> getVendorInformationTlv() {
        return this._vendorInformationTlv;
    }

    public <E extends Augmentation<Tlvs>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TlvsBuilder setLspDbVersion(LspDbVersion value) {
        this._lspDbVersion = value;
        return this;
    }

    public TlvsBuilder setRsvpErrorSpec(RsvpErrorSpec value) {
        this._rsvpErrorSpec = value;
        return this;
    }

    public TlvsBuilder setSymbolicPathName(SymbolicPathName value) {
        this._symbolicPathName = value;
        return this;
    }

    public TlvsBuilder setVendorInformationTlv(List<VendorInformationTlv> value) {
        this._vendorInformationTlv = value;
        return this;
    }

    public TlvsBuilder addAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType, Augmentation<Tlvs> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TlvsBuilder removeAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class TlvsImpl
    implements Tlvs {
        private final LspDbVersion _lspDbVersion;
        private final RsvpErrorSpec _rsvpErrorSpec;
        private final SymbolicPathName _symbolicPathName;
        private final List<VendorInformationTlv> _vendorInformationTlv;
        private Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Tlvs> getImplementedInterface() {
            return Tlvs.class;
        }

        private TlvsImpl(TlvsBuilder base) {
            this._lspDbVersion = base.getLspDbVersion();
            this._rsvpErrorSpec = base.getRsvpErrorSpec();
            this._symbolicPathName = base.getSymbolicPathName();
            this._vendorInformationTlv = base.getVendorInformationTlv();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>(base.augmentation);
                }
            }
        }

        @Override
        public LspDbVersion getLspDbVersion() {
            return this._lspDbVersion;
        }

        @Override
        public RsvpErrorSpec getRsvpErrorSpec() {
            return this._rsvpErrorSpec;
        }

        @Override
        public SymbolicPathName getSymbolicPathName() {
            return this._symbolicPathName;
        }

        public List<VendorInformationTlv> getVendorInformationTlv() {
            return this._vendorInformationTlv;
        }

        public <E extends Augmentation<Tlvs>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._lspDbVersion == null ? 0 : this._lspDbVersion.hashCode());
            result = 31 * result + (this._rsvpErrorSpec == null ? 0 : this._rsvpErrorSpec.hashCode());
            result = 31 * result + (this._symbolicPathName == null ? 0 : this._symbolicPathName.hashCode());
            result = 31 * result + (this._vendorInformationTlv == null ? 0 : this._vendorInformationTlv.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tlvs.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tlvs other = (Tlvs)obj;
            if (this._lspDbVersion == null ? other.getLspDbVersion() != null : !this._lspDbVersion.equals(other.getLspDbVersion())) {
                return false;
            }
            if (this._rsvpErrorSpec == null ? other.getRsvpErrorSpec() != null : !this._rsvpErrorSpec.equals(other.getRsvpErrorSpec())) {
                return false;
            }
            if (this._symbolicPathName == null ? other.getSymbolicPathName() != null : !this._symbolicPathName.equals(other.getSymbolicPathName())) {
                return false;
            }
            if (this._vendorInformationTlv == null ? other.getVendorInformationTlv() != null : !this._vendorInformationTlv.equals(other.getVendorInformationTlv())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TlvsImpl otherImpl = (TlvsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Tlvs [");
            boolean first = true;
            if (this._lspDbVersion != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lspDbVersion=");
                builder.append(this._lspDbVersion);
            }
            if (this._rsvpErrorSpec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rsvpErrorSpec=");
                builder.append(this._rsvpErrorSpec);
            }
            if (this._symbolicPathName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_symbolicPathName=");
                builder.append(this._symbolicPathName);
            }
            if (this._vendorInformationTlv != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vendorInformationTlv=");
                builder.append(this._vendorInformationTlv);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

