/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message.PcupdMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.pcupd.message.pcupd.message.Updates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcupdMessageBuilder
implements Builder<PcupdMessage> {
    private List<Updates> _updates;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> augmentation = Collections.emptyMap();

    public PcupdMessageBuilder() {
    }

    public PcupdMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcupdMessageBuilder(PcupdMessage base) {
        AugmentationHolder casted;
        this._updates = base.getUpdates();
        this._version = base.getVersion();
        if (base instanceof PcupdMessageImpl) {
            PcupdMessageImpl impl = (PcupdMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public List<Updates> getUpdates() {
        return this._updates;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<PcupdMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcupdMessageBuilder setUpdates(List<Updates> value) {
        this._updates = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1\u20257]].", value));
    }

    public PcupdMessageBuilder setVersion(ProtocolVersion value) {
        if (value != null) {
            PcupdMessageBuilder.checkVersionRange(value.getValue());
        }
        this._version = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _version_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
        return ret;
    }

    public PcupdMessageBuilder addAugmentation(Class<? extends Augmentation<PcupdMessage>> augmentationType, Augmentation<PcupdMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcupdMessageBuilder removeAugmentation(Class<? extends Augmentation<PcupdMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PcupdMessage build() {
        return new PcupdMessageImpl(this);
    }

    private static final class PcupdMessageImpl
    implements PcupdMessage {
        private final List<Updates> _updates;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcupdMessage> getImplementedInterface() {
            return PcupdMessage.class;
        }

        private PcupdMessageImpl(PcupdMessageBuilder base) {
            this._updates = base.getUpdates();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Updates> getUpdates() {
            return this._updates;
        }

        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<PcupdMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._updates == null ? 0 : this._updates.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcupdMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcupdMessage other = (PcupdMessage)obj;
            if (this._updates == null ? other.getUpdates() != null : !this._updates.equals(other.getUpdates())) {
                return false;
            }
            if (this._version == null ? other.getVersion() != null : !this._version.equals((Object)other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcupdMessageImpl otherImpl = (PcupdMessageImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcupdMessage [");
            boolean first = true;
            if (this._updates != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_updates=");
                builder.append(this._updates);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

