/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.rsvp.error.spec;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.rsvp.error.spec.RsvpError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.ErrorSpec;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RsvpErrorBuilder
implements Builder<RsvpError> {
    private Short _code;
    private ErrorSpec.Flags _flags;
    private IpAddress _node;
    private Integer _value;
    Map<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> augmentation = Collections.emptyMap();

    public RsvpErrorBuilder() {
    }

    public RsvpErrorBuilder(ErrorSpec arg) {
        this._node = arg.getNode();
        this._flags = arg.getFlags();
        this._code = arg.getCode();
        this._value = arg.getValue();
    }

    public RsvpErrorBuilder(RsvpError base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._flags = base.getFlags();
        this._node = base.getNode();
        this._value = base.getValue();
        if (base instanceof RsvpErrorImpl) {
            RsvpErrorImpl impl = (RsvpErrorImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ErrorSpec) {
            this._node = ((ErrorSpec)arg).getNode();
            this._flags = ((ErrorSpec)arg).getFlags();
            this._code = ((ErrorSpec)arg).getCode();
            this._value = ((ErrorSpec)arg).getValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.ErrorSpec] \nbut was: " + arg);
        }
    }

    public Short getCode() {
        return this._code;
    }

    public ErrorSpec.Flags getFlags() {
        return this._flags;
    }

    public IpAddress getNode() {
        return this._node;
    }

    public Integer getValue() {
        return this._value;
    }

    public <E extends Augmentation<RsvpError>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCodeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public RsvpErrorBuilder setCode(Short value) {
        if (value != null) {
            RsvpErrorBuilder.checkCodeRange(value);
        }
        this._code = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _code_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public RsvpErrorBuilder setFlags(ErrorSpec.Flags value) {
        this._flags = value;
        return this;
    }

    public RsvpErrorBuilder setNode(IpAddress value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    private static void checkValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public RsvpErrorBuilder setValue(Integer value) {
        if (value != null) {
            RsvpErrorBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _value_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public RsvpErrorBuilder addAugmentation(Class<? extends Augmentation<RsvpError>> augmentationType, Augmentation<RsvpError> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public RsvpErrorBuilder removeAugmentation(Class<? extends Augmentation<RsvpError>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RsvpError build() {
        return new RsvpErrorImpl(this);
    }

    private static final class RsvpErrorImpl
    implements RsvpError {
        private final Short _code;
        private final ErrorSpec.Flags _flags;
        private final IpAddress _node;
        private final Integer _value;
        private Map<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RsvpError> getImplementedInterface() {
            return RsvpError.class;
        }

        private RsvpErrorImpl(RsvpErrorBuilder base) {
            this._code = base.getCode();
            this._flags = base.getFlags();
            this._node = base.getNode();
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>>(base.augmentation);
                }
            }
        }

        public Short getCode() {
            return this._code;
        }

        public ErrorSpec.Flags getFlags() {
            return this._flags;
        }

        public IpAddress getNode() {
            return this._node;
        }

        public Integer getValue() {
            return this._value;
        }

        public <E extends Augmentation<RsvpError>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._code == null ? 0 : this._code.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RsvpError.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RsvpError other = (RsvpError)obj;
            if (this._code == null ? other.getCode() != null : !this._code.equals(other.getCode())) {
                return false;
            }
            if (this._flags == null ? other.getFlags() != null : !this._flags.equals((Object)other.getFlags())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._value == null ? other.getValue() != null : !this._value.equals(other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RsvpErrorImpl otherImpl = (RsvpErrorImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("RsvpError [");
            boolean first = true;
            if (this._code != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_code=");
                builder.append(this._code);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

