/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv.Stateful;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatefulBuilder
implements Builder<Stateful> {
    private Boolean _includeDbVersion;
    private Boolean _lspUpdateCapability;
    Map<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>> augmentation = Collections.emptyMap();

    public StatefulBuilder() {
    }

    public StatefulBuilder(Stateful base) {
        AugmentationHolder casted;
        this._includeDbVersion = base.isIncludeDbVersion();
        this._lspUpdateCapability = base.isLspUpdateCapability();
        if (base instanceof StatefulImpl) {
            StatefulImpl impl = (StatefulImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>>(casted.augmentations());
        }
    }

    public Boolean isIncludeDbVersion() {
        return this._includeDbVersion;
    }

    public Boolean isLspUpdateCapability() {
        return this._lspUpdateCapability;
    }

    public <E extends Augmentation<Stateful>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StatefulBuilder setIncludeDbVersion(Boolean value) {
        this._includeDbVersion = value;
        return this;
    }

    public StatefulBuilder setLspUpdateCapability(Boolean value) {
        this._lspUpdateCapability = value;
        return this;
    }

    public StatefulBuilder addAugmentation(Class<? extends Augmentation<Stateful>> augmentationType, Augmentation<Stateful> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StatefulBuilder removeAugmentation(Class<? extends Augmentation<Stateful>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Stateful build() {
        return new StatefulImpl(this);
    }

    private static final class StatefulImpl
    implements Stateful {
        private final Boolean _includeDbVersion;
        private final Boolean _lspUpdateCapability;
        private Map<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Stateful> getImplementedInterface() {
            return Stateful.class;
        }

        private StatefulImpl(StatefulBuilder base) {
            this._includeDbVersion = base.isIncludeDbVersion();
            this._lspUpdateCapability = base.isLspUpdateCapability();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>>(base.augmentation);
                }
            }
        }

        @Override
        public Boolean isIncludeDbVersion() {
            return this._includeDbVersion;
        }

        @Override
        public Boolean isLspUpdateCapability() {
            return this._lspUpdateCapability;
        }

        public <E extends Augmentation<Stateful>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._includeDbVersion == null ? 0 : this._includeDbVersion.hashCode());
            result = 31 * result + (this._lspUpdateCapability == null ? 0 : this._lspUpdateCapability.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Stateful.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Stateful other = (Stateful)obj;
            if (this._includeDbVersion == null ? other.isIncludeDbVersion() != null : !this._includeDbVersion.equals(other.isIncludeDbVersion())) {
                return false;
            }
            if (this._lspUpdateCapability == null ? other.isLspUpdateCapability() != null : !this._lspUpdateCapability.equals(other.isLspUpdateCapability())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StatefulImpl otherImpl = (StatefulImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Stateful>>, Augmentation<Stateful>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Stateful [");
            boolean first = true;
            if (this._includeDbVersion != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeDbVersion=");
                builder.append(this._includeDbVersion);
            }
            if (this._lspUpdateCapability != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lspUpdateCapability=");
                builder.append(this._lspUpdateCapability);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

