package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Configuration for the PCEP implementation.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * module pcep-app-config {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:controller:pcep:app-config;
 *   prefix pcep-app-config;
 *   revision 2016-07-07 {
 *   }
 *   container pcep-session-config {
 *     leaf dead-timer-value {
 *       type uint16;
 *       default 120;
 *     }
 *     leaf keep-alive-timer-value {
 *       type uint16;
 *       default 30;
 *     }
 *   }
 *   typedef path-type {
 *     type enumeration {
 *       enum PATH;
 *       enum CLASSPATH;
 *     }
 *   }
 *   typedef store-type {
 *     type enumeration {
 *       enum JKS;
 *       enum PKCS12;
 *     }
 *   }
 *   container pcep-dispatcher-config {
 *     leaf max-unknown-messages {
 *       type uint16 {
 *         range 1..max;
 *       }
 *       default 5;
 *     }
 *     container tls {
 *       presence true;
 *       leaf keystore {
 *         type string;
 *       }
 *       leaf keystore-type {
 *         type store-type;
 *       }
 *       leaf keystore-path-type {
 *         type path-type;
 *       }
 *       leaf keystore-password {
 *         type string;
 *       }
 *       leaf certificate-password {
 *         type string;
 *       }
 *       leaf truststore {
 *         type string;
 *       }
 *       leaf truststore-type {
 *         type store-type;
 *       }
 *       leaf truststore-path-type {
 *         type path-type;
 *       }
 *       leaf truststore-password {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface PcepAppConfigData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig</code> <code>pcepSessionConfig</code>, or <code>null</code> if not present
     */
    @Nullable
    PcepSessionConfig getPcepSessionConfig();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig</code> <code>pcepDispatcherConfig</code>, or <code>null</code> if not present
     */
    @Nullable
    PcepDispatcherConfig getPcepDispatcherConfig();

}

