package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import java.lang.Integer;
import javax.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container pcep-dispatcher-config {
 *   leaf max-unknown-messages {
 *     type uint16 {
 *       range 1..max;
 *     }
 *     default 5;
 *   }
 *   container tls {
 *     presence true;
 *     leaf keystore {
 *       type string;
 *     }
 *     leaf keystore-type {
 *       type store-type;
 *     }
 *     leaf keystore-path-type {
 *       type path-type;
 *     }
 *     leaf keystore-password {
 *       type string;
 *     }
 *     leaf certificate-password {
 *       type string;
 *     }
 *     leaf truststore {
 *       type string;
 *     }
 *     leaf truststore-type {
 *       type store-type;
 *     }
 *     leaf truststore-path-type {
 *       type path-type;
 *     }
 *     leaf truststore-password {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-app-config/pcep-dispatcher-config</i>
 *
 * <p>To create instances of this class use {@link PcepDispatcherConfigBuilder}.
 * @see PcepDispatcherConfigBuilder
 *
 */
public interface PcepDispatcherConfig
    extends
    ChildOf<PcepAppConfigData>,
    Augmentable<PcepDispatcherConfig>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("pcep-dispatcher-config");

    /**
     * @return <code>java.lang.Integer</code> <code>maxUnknownMessages</code>, or <code>null</code> if not present
     */
    @Nullable
    Integer getMaxUnknownMessages();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls</code> <code>tls</code>, or <code>null</code> if not present
     */
    @Nullable
    Tls getTls();

}

