package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PcepDispatcherConfigBuilder} instances.
 *
 * @see PcepDispatcherConfigBuilder
 *
 */
public class PcepDispatcherConfigBuilder implements Builder<PcepDispatcherConfig> {

    private Integer _maxUnknownMessages;
    private Tls _tls;


    Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> augmentation = Collections.emptyMap();

    public PcepDispatcherConfigBuilder() {
    }

    public PcepDispatcherConfigBuilder(PcepDispatcherConfig base) {
        this._maxUnknownMessages = base.getMaxUnknownMessages();
        this._tls = base.getTls();
        if (base instanceof PcepDispatcherConfigImpl) {
            PcepDispatcherConfigImpl impl = (PcepDispatcherConfigImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<PcepDispatcherConfig> casted =(AugmentationHolder<PcepDispatcherConfig>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Integer getMaxUnknownMessages() {
        return _maxUnknownMessages;
    }
    
    public Tls getTls() {
        return _tls;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<PcepDispatcherConfig>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaxUnknownMessagesRange(final int value) {
        if (value >= 1 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..65535]]", value);
    }
    
    public PcepDispatcherConfigBuilder setMaxUnknownMessages(final Integer value) {
    if (value != null) {
        checkMaxUnknownMessagesRange(value);
        
    }
        this._maxUnknownMessages = value;
        return this;
    }
    
    public PcepDispatcherConfigBuilder setTls(final Tls value) {
        this._tls = value;
        return this;
    }
    
    public PcepDispatcherConfigBuilder addAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType, Augmentation<PcepDispatcherConfig> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public PcepDispatcherConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepDispatcherConfig build() {
        return new PcepDispatcherConfigImpl(this);
    }

    private static final class PcepDispatcherConfigImpl implements PcepDispatcherConfig {
    
        private final Integer _maxUnknownMessages;
        private final Tls _tls;
    
        private Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> augmentation = Collections.emptyMap();
    
        private PcepDispatcherConfigImpl(PcepDispatcherConfigBuilder base) {
            this._maxUnknownMessages = base.getMaxUnknownMessages();
            this._tls = base.getTls();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<PcepDispatcherConfig> getImplementedInterface() {
            return PcepDispatcherConfig.class;
        }
    
        @Override
        public Integer getMaxUnknownMessages() {
            return _maxUnknownMessages;
        }
        
        @Override
        public Tls getTls() {
            return _tls;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<PcepDispatcherConfig>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_maxUnknownMessages);
            result = prime * result + Objects.hashCode(_tls);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepDispatcherConfig.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepDispatcherConfig other = (PcepDispatcherConfig)obj;
            if (!Objects.equals(_maxUnknownMessages, other.getMaxUnknownMessages())) {
                return false;
            }
            if (!Objects.equals(_tls, other.getTls())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PcepDispatcherConfigImpl otherImpl = (PcepDispatcherConfigImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepDispatcherConfig");
            CodeHelpers.appendValue(helper, "_maxUnknownMessages", _maxUnknownMessages);
            CodeHelpers.appendValue(helper, "_tls", _tls);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
