package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import java.lang.Integer;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container pcep-session-config {
 *   leaf dead-timer-value {
 *     type uint16;
 *     default 120;
 *   }
 *   leaf keep-alive-timer-value {
 *     type uint16;
 *     default 30;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-app-config/pcep-session-config</i>
 *
 * <p>To create instances of this class use {@link PcepSessionConfigBuilder}.
 * @see PcepSessionConfigBuilder
 *
 */
public interface PcepSessionConfig
    extends
    ChildOf<PcepAppConfigData>,
    Augmentable<PcepSessionConfig>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("pcep-session-config");

    /**
     * @return <code>java.lang.Integer</code> <code>deadTimerValue</code>, or <code>null</code> if not present
     */
    @Nullable
    Integer getDeadTimerValue();
    
    /**
     * @return <code>java.lang.Integer</code> <code>keepAliveTimerValue</code>, or <code>null</code> if not present
     */
    @Nullable
    Integer getKeepAliveTimerValue();

}

