package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TlsBuilder} instances.
 *
 * @see TlsBuilder
 *
 */
public class TlsBuilder implements Builder<Tls> {

    private String _certificatePassword;
    private String _keystore;
    private String _keystorePassword;
    private PathType _keystorePathType;
    private StoreType _keystoreType;
    private String _truststore;
    private String _truststorePassword;
    private PathType _truststorePathType;
    private StoreType _truststoreType;


    Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Collections.emptyMap();

    public TlsBuilder() {
    }

    public TlsBuilder(Tls base) {
        this._certificatePassword = base.getCertificatePassword();
        this._keystore = base.getKeystore();
        this._keystorePassword = base.getKeystorePassword();
        this._keystorePathType = base.getKeystorePathType();
        this._keystoreType = base.getKeystoreType();
        this._truststore = base.getTruststore();
        this._truststorePassword = base.getTruststorePassword();
        this._truststorePathType = base.getTruststorePathType();
        this._truststoreType = base.getTruststoreType();
        if (base instanceof TlsImpl) {
            TlsImpl impl = (TlsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<Tls> casted =(AugmentationHolder<Tls>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public String getCertificatePassword() {
        return _certificatePassword;
    }
    
    public String getKeystore() {
        return _keystore;
    }
    
    public String getKeystorePassword() {
        return _keystorePassword;
    }
    
    public PathType getKeystorePathType() {
        return _keystorePathType;
    }
    
    public StoreType getKeystoreType() {
        return _keystoreType;
    }
    
    public String getTruststore() {
        return _truststore;
    }
    
    public String getTruststorePassword() {
        return _truststorePassword;
    }
    
    public PathType getTruststorePathType() {
        return _truststorePathType;
    }
    
    public StoreType getTruststoreType() {
        return _truststoreType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<Tls>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public TlsBuilder setCertificatePassword(final String value) {
        this._certificatePassword = value;
        return this;
    }
    
    public TlsBuilder setKeystore(final String value) {
        this._keystore = value;
        return this;
    }
    
    public TlsBuilder setKeystorePassword(final String value) {
        this._keystorePassword = value;
        return this;
    }
    
    public TlsBuilder setKeystorePathType(final PathType value) {
        this._keystorePathType = value;
        return this;
    }
    
    public TlsBuilder setKeystoreType(final StoreType value) {
        this._keystoreType = value;
        return this;
    }
    
    public TlsBuilder setTruststore(final String value) {
        this._truststore = value;
        return this;
    }
    
    public TlsBuilder setTruststorePassword(final String value) {
        this._truststorePassword = value;
        return this;
    }
    
    public TlsBuilder setTruststorePathType(final PathType value) {
        this._truststorePathType = value;
        return this;
    }
    
    public TlsBuilder setTruststoreType(final StoreType value) {
        this._truststoreType = value;
        return this;
    }
    
    public TlsBuilder addAugmentation(Class<? extends Augmentation<Tls>> augmentationType, Augmentation<Tls> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public TlsBuilder removeAugmentation(Class<? extends Augmentation<Tls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tls build() {
        return new TlsImpl(this);
    }

    private static final class TlsImpl implements Tls {
    
        private final String _certificatePassword;
        private final String _keystore;
        private final String _keystorePassword;
        private final PathType _keystorePathType;
        private final StoreType _keystoreType;
        private final String _truststore;
        private final String _truststorePassword;
        private final PathType _truststorePathType;
        private final StoreType _truststoreType;
    
        private Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Collections.emptyMap();
    
        private TlsImpl(TlsBuilder base) {
            this._certificatePassword = base.getCertificatePassword();
            this._keystore = base.getKeystore();
            this._keystorePassword = base.getKeystorePassword();
            this._keystorePathType = base.getKeystorePathType();
            this._keystoreType = base.getKeystoreType();
            this._truststore = base.getTruststore();
            this._truststorePassword = base.getTruststorePassword();
            this._truststorePathType = base.getTruststorePathType();
            this._truststoreType = base.getTruststoreType();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<Tls> getImplementedInterface() {
            return Tls.class;
        }
    
        @Override
        public String getCertificatePassword() {
            return _certificatePassword;
        }
        
        @Override
        public String getKeystore() {
            return _keystore;
        }
        
        @Override
        public String getKeystorePassword() {
            return _keystorePassword;
        }
        
        @Override
        public PathType getKeystorePathType() {
            return _keystorePathType;
        }
        
        @Override
        public StoreType getKeystoreType() {
            return _keystoreType;
        }
        
        @Override
        public String getTruststore() {
            return _truststore;
        }
        
        @Override
        public String getTruststorePassword() {
            return _truststorePassword;
        }
        
        @Override
        public PathType getTruststorePathType() {
            return _truststorePathType;
        }
        
        @Override
        public StoreType getTruststoreType() {
            return _truststoreType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<Tls>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_certificatePassword);
            result = prime * result + Objects.hashCode(_keystore);
            result = prime * result + Objects.hashCode(_keystorePassword);
            result = prime * result + Objects.hashCode(_keystorePathType);
            result = prime * result + Objects.hashCode(_keystoreType);
            result = prime * result + Objects.hashCode(_truststore);
            result = prime * result + Objects.hashCode(_truststorePassword);
            result = prime * result + Objects.hashCode(_truststorePathType);
            result = prime * result + Objects.hashCode(_truststoreType);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tls.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tls other = (Tls)obj;
            if (!Objects.equals(_certificatePassword, other.getCertificatePassword())) {
                return false;
            }
            if (!Objects.equals(_keystore, other.getKeystore())) {
                return false;
            }
            if (!Objects.equals(_keystorePassword, other.getKeystorePassword())) {
                return false;
            }
            if (!Objects.equals(_keystorePathType, other.getKeystorePathType())) {
                return false;
            }
            if (!Objects.equals(_keystoreType, other.getKeystoreType())) {
                return false;
            }
            if (!Objects.equals(_truststore, other.getTruststore())) {
                return false;
            }
            if (!Objects.equals(_truststorePassword, other.getTruststorePassword())) {
                return false;
            }
            if (!Objects.equals(_truststorePathType, other.getTruststorePathType())) {
                return false;
            }
            if (!Objects.equals(_truststoreType, other.getTruststoreType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TlsImpl otherImpl = (TlsImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tls");
            CodeHelpers.appendValue(helper, "_certificatePassword", _certificatePassword);
            CodeHelpers.appendValue(helper, "_keystore", _keystore);
            CodeHelpers.appendValue(helper, "_keystorePassword", _keystorePassword);
            CodeHelpers.appendValue(helper, "_keystorePathType", _keystorePathType);
            CodeHelpers.appendValue(helper, "_keystoreType", _keystoreType);
            CodeHelpers.appendValue(helper, "_truststore", _truststore);
            CodeHelpers.appendValue(helper, "_truststorePassword", _truststorePassword);
            CodeHelpers.appendValue(helper, "_truststorePathType", _truststorePathType);
            CodeHelpers.appendValue(helper, "_truststoreType", _truststoreType);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
