/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.base.Ticker;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionTest;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.impl.SimpleSessionListener;
import org.opendaylight.protocol.pcep.impl.SslContextFactoryTest;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.util.CheckUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.TlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Starttls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yangtools.yang.binding.Notification;

public class FiniteStateMachineTest
extends AbstractPCEPSessionTest {
    private DefaultPCEPSessionNegotiator serverSession;
    private DefaultPCEPSessionNegotiator tlsSessionNegotiator;
    private final TestTicker ticker = new TestTicker();

    @Before
    public void setup() {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open localPrefs = new OpenBuilder().setKeepalive(Short.valueOf((short)1)).build();
        this.serverSession = new DefaultPCEPSessionNegotiator((Promise)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), this.channel, (PCEPSessionListener)this.listener, 1, 20, localPrefs);
        this.tlsSessionNegotiator = new DefaultPCEPSessionNegotiator((Promise)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), this.channel, (PCEPSessionListener)this.listener, 1, 20, localPrefs, new TlsBuilder().build());
    }

    @Test
    public void testSessionCharsAccBoth() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Open));
        this.serverSession.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Keepalive));
        this.serverSession.handleMessage((Message)this.kaMsg);
        Assert.assertEquals((Object)this.serverSession.getState(), (Object)AbstractPCEPSessionNegotiator.State.FINISHED);
    }

    @Test
    public void testEstablishTLS() {
        DefaultPCEPSessionNegotiator negotiator = new DefaultPCEPSessionNegotiator((Promise)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), this.channel, (PCEPSessionListener)this.listener, 1, 20, new OpenBuilder().setKeepalive(Short.valueOf((short)1)).build(), SslContextFactoryTest.createTlsConfig());
        negotiator.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Starttls));
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.START_TLS_WAIT, (Object)negotiator.getState());
        negotiator.handleMessage((Message)this.startTlsMsg);
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.OPEN_WAIT, (Object)negotiator.getState());
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Open));
        negotiator.handleMessage((Message)this.openMsg);
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.KEEP_WAIT, (Object)negotiator.getState());
    }

    @Test
    public void testFailedToEstablishTLS() throws Exception {
        this.tlsSessionNegotiator.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Starttls));
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.START_TLS_WAIT, (Object)this.tlsSessionNegotiator.getState());
        this.tlsSessionNegotiator.handleMessage((Message)this.startTlsMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Pcerr));
        Errors obj = (Errors)((Pcerr)this.msgsSend.get(1)).getPcerrMessage().getErrors().get(0);
        Assert.assertEquals((long)PCEPErrors.NOT_POSSIBLE_WITHOUT_TLS.getErrorType(), (long)obj.getErrorObject().getType().shortValue());
        Assert.assertEquals((long)PCEPErrors.NOT_POSSIBLE_WITHOUT_TLS.getErrorValue(), (long)obj.getErrorObject().getValue().shortValue());
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.FINISHED, (Object)this.tlsSessionNegotiator.getState());
    }

    @Test
    public void testTLSUnexpectedMessage() {
        this.tlsSessionNegotiator.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Starttls));
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.START_TLS_WAIT, (Object)this.tlsSessionNegotiator.getState());
        this.tlsSessionNegotiator.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Pcerr));
        Errors obj = (Errors)((Pcerr)this.msgsSend.get(1)).getPcerrMessage().getErrors().get(0);
        Assert.assertEquals((long)PCEPErrors.NON_STARTTLS_MSG_RCVD.getErrorType(), (long)obj.getErrorObject().getType().shortValue());
        Assert.assertEquals((long)PCEPErrors.NON_STARTTLS_MSG_RCVD.getErrorValue(), (long)obj.getErrorObject().getValue().shortValue());
        Assert.assertEquals((Object)this.tlsSessionNegotiator.getState(), (Object)AbstractPCEPSessionNegotiator.State.FINISHED);
    }

    @Test
    public void testSessionCharsAccMe() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Open));
        Open remote = (Open)this.msgsSend.get(0);
        this.serverSession.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Keepalive));
        this.serverSession.handleMessage(Util.createErrorMessage((PCEPErrors)PCEPErrors.NON_ACC_NEG_SESSION_CHAR, (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open)remote.getOpenMessage().getOpen()));
        Assert.assertEquals((long)3L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(2) instanceof Open));
        this.serverSession.handleMessage((Message)this.kaMsg);
        Assert.assertEquals((Object)this.serverSession.getState(), (Object)AbstractPCEPSessionNegotiator.State.FINISHED);
    }

    @Test
    public void testErrorOneOne() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Open));
        this.serverSession.handleMessage((Message)this.kaMsg);
        CheckUtil.checkEquals(() -> {
            for (Notification m : this.msgsSend) {
                if (!(m instanceof Pcerr)) continue;
                Errors obj = (Errors)((Pcerr)m).getPcerrMessage().getErrors().get(0);
                Assert.assertEquals((Object)new Short(1), (Object)obj.getErrorObject().getType());
                Assert.assertEquals((Object)new Short(1), (Object)obj.getErrorObject().getValue());
            }
        });
    }

    @Test
    public void testErrorOneSeven() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Open));
        this.serverSession.handleMessage((Message)this.openMsg);
        CheckUtil.checkEquals(() -> {
            for (Notification m : this.msgsSend) {
                if (!(m instanceof Pcerr)) continue;
                Errors obj = (Errors)((Pcerr)m).getPcerrMessage().getErrors().get(0);
                Assert.assertEquals((Object)new Short(1), (Object)obj.getErrorObject().getType());
                Assert.assertEquals((Object)new Short(7), (Object)obj.getErrorObject().getValue());
            }
        });
    }

    @Test
    public void testErrorOneTwo() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof OpenMessage));
        CheckUtil.checkEquals(() -> {
            for (Notification m : this.msgsSend) {
                if (!(m instanceof Pcerr)) continue;
                Errors obj = (Errors)((Pcerr)m).getPcerrMessage().getErrors().get(0);
                Assert.assertEquals((Object)new Short(1), (Object)obj.getErrorObject().getType());
                Assert.assertEquals((Object)new Short(2), (Object)obj.getErrorObject().getValue());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnknownMessage() throws Exception {
        SimpleSessionListener client = new SimpleSessionListener();
        PCEPSessionImpl session = new PCEPSessionImpl((PCEPSessionListener)client, 5, this.channel, this.openMsg.getOpenMessage().getOpen(), this.openMsg.getOpenMessage().getOpen());
        PCEPSessionImpl.setTicker((Ticker)this.ticker);
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Queue qeue = session.getUnknownMessagesTimes();
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)1L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)2L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)3L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)4L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)3L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)3L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)4L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        CheckUtil.checkEquals(() -> Assert.assertEquals((long)5L, (long)qeue.size()));
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        SimpleSessionListener simpleSessionListener = client;
        synchronized (simpleSessionListener) {
            while (client.up) {
                client.wait();
            }
        }
        CheckUtil.checkEquals(() -> Assert.assertTrue((!client.up ? 1 : 0) != 0));
    }

    @After
    public void tearDown() {
    }

    private final class TestTicker
    extends Ticker {
        private long counter = 0L;

        TestTicker() {
        }

        public long read() {
            if (this.counter == 8L) {
                ++this.counter;
                return 60000000003L;
            }
            if (this.counter == 10L) {
                ++this.counter;
                return 60000000006L;
            }
            return this.counter++;
        }
    }
}

