/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.parser.subobject.GeneralizedLabelParser;
import org.opendaylight.protocol.pcep.parser.subobject.Type1LabelParser;
import org.opendaylight.protocol.pcep.parser.subobject.WavebandSwitchingLabelParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.GeneralizedLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.Type1LabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.WavebandSwitchingLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.generalized.label._case.GeneralizedLabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.type1.label._case.Type1LabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case.WavebandSwitchingLabelBuilder;

public class LabelSubobjectParserTest {
    private static final byte[] generalizedLabelBytes = new byte[]{-128, 2, 0, 4, 18, 0, 37, -1};
    private static final byte[] typeOneLabelBytes = new byte[]{-127, 1, 18, 0, 37, -1};
    private static final byte[] wavebandLabelBytes = new byte[]{1, 3, 0, 0, 18, 52, 0, 0, -103, -103, 0, 0, 17, 17};

    @Test
    public void testGeneralizedLabel() throws PCEPDeserializerException {
        GeneralizedLabelParser parser = new GeneralizedLabelParser();
        GeneralizedLabelBuilder iBuilder = new GeneralizedLabelBuilder();
        iBuilder.setGeneralizedLabel(ByteArray.cutBytes((byte[])generalizedLabelBytes, (int)2));
        GeneralizedLabelCaseBuilder builder = new GeneralizedLabelCaseBuilder().setGeneralizedLabel(iBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseLabel(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])generalizedLabelBytes, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeLabel(true, false, (LabelType)builder.build(), buff);
        Assert.assertArrayEquals((byte[])generalizedLabelBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseLabel(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseLabel(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testWavebandLabel() throws PCEPDeserializerException {
        WavebandSwitchingLabelParser parser = new WavebandSwitchingLabelParser();
        WavebandSwitchingLabelBuilder iBuilder = new WavebandSwitchingLabelBuilder();
        iBuilder.setWavebandId(Long.valueOf(4660L));
        iBuilder.setStartLabel(Long.valueOf(39321L));
        iBuilder.setEndLabel(Long.valueOf(4369L));
        WavebandSwitchingLabelCaseBuilder builder = new WavebandSwitchingLabelCaseBuilder().setWavebandSwitchingLabel(iBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseLabel(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])wavebandLabelBytes, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeLabel(false, true, (LabelType)builder.build(), buff);
        Assert.assertArrayEquals((byte[])wavebandLabelBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseLabel(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseLabel(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testTypeOneLabel() throws PCEPDeserializerException {
        Type1LabelParser parser = new Type1LabelParser();
        Type1LabelBuilder iBuilder = new Type1LabelBuilder();
        iBuilder.setType1Label(Long.valueOf(301999615L));
        Type1LabelCaseBuilder builder = new Type1LabelCaseBuilder().setType1Label(iBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseLabel(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])typeOneLabelBytes, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeLabel(true, true, (LabelType)builder.build(), buff);
        Assert.assertArrayEquals((byte[])typeOneLabelBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseLabel(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseLabel(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }
}

