/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.opendaylight.protocol.pcep.PCEPDispatcherDependencies;
import org.opendaylight.protocol.pcep.PCEPSessionListenerFactory;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.PCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.impl.BasePCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.PCEPDispatcherImpl;
import org.opendaylight.protocol.pcep.impl.PCEPHandlerFactory;
import org.opendaylight.protocol.pcep.impl.PCEPProtocolSessionPromise;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.impl.SimpleSessionListener;
import org.opendaylight.protocol.pcep.spi.MessageRegistry;
import org.opendaylight.protocol.pcep.spi.pojo.ServiceLoaderPCEPExtensionProviderContext;
import org.opendaylight.protocol.util.InetSocketAddressUtil;

public class PCEPDispatcherImplTest {
    private static final short DEAD_TIMER = 120;
    private static final short KEEP_ALIVE = 30;
    private static final int RETRY_TIMER = 0;
    private static final int CONNECT_TIMEOUT = 500;
    private PCEPDispatcherImpl dispatcher;
    private PCEPDispatcherImpl disp2Spy;
    @Mock
    private java.nio.channels.Channel mockChannel;
    @Mock
    private PCEPDispatcherDependencies dispatcherDependencies;
    @Mock
    private PCEPSessionListenerFactory listenerFactory;
    private PCCMock pccMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ArrayList capList = new ArrayList();
        BasePCEPSessionProposalFactory sessionProposal = new BasePCEPSessionProposalFactory(120, 30, capList);
        Object eventLoopGroup = Epoll.isAvailable() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        MessageRegistry msgReg = ServiceLoaderPCEPExtensionProviderContext.getSingletonInstance().getMessageHandlerRegistry();
        this.dispatcher = new PCEPDispatcherImpl(msgReg, (PCEPSessionNegotiatorFactory)new DefaultPCEPSessionNegotiatorFactory((PCEPSessionProposalFactory)sessionProposal, 0), (EventLoopGroup)eventLoopGroup, (EventLoopGroup)eventLoopGroup);
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)KeyMapping.getKeyMapping()).when((Object)this.dispatcherDependencies)).getKeys();
        ((PCEPDispatcherDependencies)Mockito.doReturn(null).when((Object)this.dispatcherDependencies)).getPeerProposal();
        ((java.nio.channels.Channel)Mockito.doReturn((Object)"mockChannel").when((Object)this.mockChannel)).toString();
        PCEPDispatcherImpl dispatcher2 = new PCEPDispatcherImpl(msgReg, (PCEPSessionNegotiatorFactory)new DefaultPCEPSessionNegotiatorFactory((PCEPSessionProposalFactory)sessionProposal, 0), (EventLoopGroup)eventLoopGroup, (EventLoopGroup)eventLoopGroup);
        this.disp2Spy = (PCEPDispatcherImpl)Mockito.spy((Object)dispatcher2);
        this.pccMock = new PCCMock((PCEPSessionNegotiatorFactory<PCEPSessionImpl>)new DefaultPCEPSessionNegotiatorFactory((PCEPSessionProposalFactory)sessionProposal, 0), new PCEPHandlerFactory(msgReg));
    }

    @Test(timeout=20000L)
    public void testCreateClientServer() throws InterruptedException, ExecutionException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress serverAddr = new InetSocketAddress("0.0.0.0", port);
        InetSocketAddress clientAddr1 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        InetSocketAddress clientAddr2 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)serverAddr).when((Object)this.dispatcherDependencies)).getAddress();
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)this.listenerFactory).when((Object)this.dispatcherDependencies)).getListenerFactory();
        ((PCEPSessionListenerFactory)Mockito.doReturn((Object)new SimpleSessionListener()).when((Object)this.listenerFactory)).getSessionListener();
        ChannelFuture futureChannel = this.dispatcher.createServer(this.dispatcherDependencies);
        futureChannel.sync();
        PCEPSessionImpl session1 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr1, 0, 500, SimpleSessionListener::new).get();
        PCEPSessionImpl session2 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr2, 0, 500, SimpleSessionListener::new).get();
        Assert.assertTrue((boolean)futureChannel.channel().isActive());
        Assert.assertEquals((Object)clientAddr1.getAddress().getHostAddress(), (Object)session1.getPeerPref().getIpAddress());
        Assert.assertEquals((long)120L, (long)session1.getDeadTimerValue().shortValue());
        Assert.assertEquals((long)30L, (long)session1.getKeepAliveTimerValue().shortValue());
        Assert.assertEquals((Object)clientAddr2.getAddress().getHostAddress(), (Object)session2.getPeerPref().getIpAddress());
        Assert.assertEquals((long)120L, (long)session2.getDeadTimerValue().shortValue());
        Assert.assertEquals((long)30L, (long)session2.getKeepAliveTimerValue().shortValue());
        session1.close();
        session2.close();
        Assert.assertTrue((boolean)futureChannel.channel().isActive());
    }

    @Test(timeout=20000L)
    public void testCreateDuplicateClient() throws InterruptedException, ExecutionException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress serverAddr = new InetSocketAddress("0.0.0.0", port);
        InetSocketAddress clientAddr = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)serverAddr).when((Object)this.dispatcherDependencies)).getAddress();
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)this.listenerFactory).when((Object)this.dispatcherDependencies)).getListenerFactory();
        ((PCEPSessionListenerFactory)Mockito.doReturn((Object)new SimpleSessionListener()).when((Object)this.listenerFactory)).getSessionListener();
        this.dispatcher.createServer(this.dispatcherDependencies).sync();
        Future<PCEPSessionImpl> futureClient = this.pccMock.createClient(clientAddr, 0, 500, SimpleSessionListener::new);
        futureClient.sync();
        try (PCEPSessionImpl ignored = (PCEPSessionImpl)futureClient.get();){
            this.pccMock.createClient(clientAddr, 0, 500, SimpleSessionListener::new).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("A conflicting session for address"));
        }
    }

    @Test(timeout=20000L)
    public void testReconectClient() throws InterruptedException, ExecutionException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress clientAddr = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)new InetSocketAddress("0.0.0.0", port)).when((Object)this.dispatcherDependencies)).getAddress();
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)this.listenerFactory).when((Object)this.dispatcherDependencies)).getListenerFactory();
        ((PCEPSessionListenerFactory)Mockito.doReturn((Object)new SimpleSessionListener()).when((Object)this.listenerFactory)).getSessionListener();
        this.dispatcher.createServer(this.dispatcherDependencies).sync();
        PCEPSessionImpl session1 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr, 0, 500, SimpleSessionListener::new).get();
        Assert.assertEquals((Object)clientAddr.getAddress(), (Object)session1.getRemoteAddress());
        Assert.assertEquals((long)120L, (long)session1.getDeadTimerValue().shortValue());
        Assert.assertEquals((long)30L, (long)session1.getKeepAliveTimerValue().shortValue());
        session1.closeChannel().sync();
        PCEPSessionImpl session2 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr, 0, 500, SimpleSessionListener::new).get();
        Assert.assertEquals((Object)clientAddr.getAddress(), (Object)session1.getRemoteAddress());
        Assert.assertEquals((long)120L, (long)session2.getDeadTimerValue().shortValue());
        Assert.assertEquals((long)30L, (long)session2.getKeepAliveTimerValue().shortValue());
        session2.close();
    }

    @Test(timeout=20000L)
    public void testCustomizeBootstrap() throws InterruptedException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress clientAddr1 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        InetSocketAddress clientAddr2 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        KeyMapping keys = KeyMapping.getKeyMapping((InetAddress)clientAddr1.getAddress(), (String)"CLIENT1_ADDRESS");
        keys.put((Object)clientAddr2.getAddress(), (Object)"CLIENT2_ADDRESS".getBytes());
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)new InetSocketAddress("0.0.0.0", port)).when((Object)this.dispatcherDependencies)).getAddress();
        ((PCEPDispatcherDependencies)Mockito.doReturn((Object)this.listenerFactory).when((Object)this.dispatcherDependencies)).getListenerFactory();
        ((PCEPSessionListenerFactory)Mockito.doReturn((Object)new SimpleSessionListener()).when((Object)this.listenerFactory)).getSessionListener();
        ChannelFuture futureChannel = this.disp2Spy.createServer(this.dispatcherDependencies);
        futureChannel.sync();
        ((PCEPDispatcherImpl)Mockito.verify((Object)this.disp2Spy)).createServerBootstrap((PCEPDispatcherImpl.ChannelPipelineInitializer)Matchers.any(PCEPDispatcherImpl.ChannelPipelineInitializer.class));
    }

    @After
    public void tearDown() {
        this.dispatcher.close();
        this.disp2Spy.close();
    }

    private static class PCCMock {
        private final PCEPSessionNegotiatorFactory<PCEPSessionImpl> negotiatorFactory;
        private final PCEPHandlerFactory factory;
        private final EventExecutor executor;
        private final EventLoopGroup workerGroup = new NioEventLoopGroup();

        PCCMock(PCEPSessionNegotiatorFactory<PCEPSessionImpl> negotiatorFactory, PCEPHandlerFactory factory) {
            this.negotiatorFactory = Objects.requireNonNull(negotiatorFactory);
            this.factory = Objects.requireNonNull(factory);
            this.executor = (EventExecutor)Objects.requireNonNull(GlobalEventExecutor.INSTANCE);
        }

        Future<PCEPSessionImpl> createClient(InetSocketAddress address, int retryTimer, int connectTimeout, PCEPSessionListenerFactory listenerFactory) {
            return this.createClient(address, retryTimer, connectTimeout, (ch, promise) -> {
                ch.pipeline().addLast(this.factory.getDecoders());
                ch.pipeline().addLast("negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator(() -> listenerFactory, (Channel)ch, promise));
                ch.pipeline().addLast(this.factory.getEncoders());
            });
        }

        Future<PCEPSessionImpl> createClient(InetSocketAddress address, int retryTimer, int connectTimeout, final PCEPDispatcherImpl.ChannelPipelineInitializer initializer) {
            Bootstrap b = new Bootstrap();
            final PCEPProtocolSessionPromise p = new PCEPProtocolSessionPromise(this.executor, address, retryTimer, connectTimeout, b);
            ((Bootstrap)b.option(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    initializer.initializeChannel(ch, (Promise)p);
                }
            });
            this.setWorkerGroup(b);
            PCCMock.setChannelFactory(b);
            p.connect();
            return p;
        }

        private static void setChannelFactory(Bootstrap b) {
            try {
                b.channel(NioSocketChannel.class);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        private void setWorkerGroup(Bootstrap b) {
            if (b.config().group() == null) {
                b.group(this.workerGroup);
            }
        }
    }
}

