/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationActivator;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationObjectParser;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationTlvParser;
import org.opendaylight.protocol.pcep.parser.BaseParserExtensionActivator;
import org.opendaylight.protocol.pcep.parser.object.PCEPBandwidthObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPClassTypeObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPCloseObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPEndPointsIpv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPEndPointsIpv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPErrorObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPExcludeRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPExistingBandwidthObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPExplicitRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPGlobalConstraintsObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPIncludeRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPLoadBalancingObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPLspaObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPMetricObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPMonitoringObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPNoPathObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPNotificationObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPObjectiveFunctionObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPOpenObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPOverloadObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPathKeyObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPccIdReqIPv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPccIdReqIPv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPceIdIPv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPceIdIPv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPProcTimeObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPReportedRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPRequestParameterObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPSvecObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectHeaderImpl;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.pcep.spi.pojo.SimplePCEPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathVectorTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.BandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.classtype.object.ClassTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object.CCloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.Ipv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.Ipv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv4._case.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv6._case.Ipv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.XroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.EroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.GcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.IroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.MetricBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.MonitoringBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.c.notification.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.OfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.OrderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.duration.tlv.OverloadDurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.object.OverloadBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKeyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeysBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.NoPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTimeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reoptimization.bandwidth.object.ReoptimizationBandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.RroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.req.missing.tlv.ReqMissingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.RpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.SvecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;

public class PCEPObjectParserTest {
    private TlvRegistry tlvRegistry;
    private VendorInformationTlvRegistry viTlvRegistry;
    private SimplePCEPExtensionProviderContext ctx;
    private BaseParserExtensionActivator act;
    private TestVendorInformationActivator viAct;

    @Before
    public void setUp() {
        this.ctx = new SimplePCEPExtensionProviderContext();
        this.act = new BaseParserExtensionActivator();
        this.viAct = new TestVendorInformationActivator();
        this.act.start((PCEPExtensionProviderContext)this.ctx);
        this.viAct.start((PCEPExtensionProviderContext)this.ctx);
        this.tlvRegistry = this.ctx.getTlvHandlerRegistry();
        this.viTlvRegistry = this.ctx.getVendorInformationTlvRegistry();
    }

    @Test
    public void testOpenObjectWOTLV() throws PCEPDeserializerException, IOException {
        PCEPOpenObjectParser parser = new PCEPOpenObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPOpenObject1.bin"));
        OpenBuilder builder = new OpenBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setVersion(new ProtocolVersion(Short.valueOf((short)1)));
        builder.setKeepalive(Short.valueOf((short)30));
        builder.setDeadTimer(Short.valueOf((short)120));
        builder.setSessionId(Short.valueOf((short)1));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder().build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testCloseObject() throws IOException, PCEPDeserializerException {
        PCEPCloseObjectParser parser = new PCEPCloseObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPCloseObject1.bin"));
        CCloseBuilder builder = new CCloseBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setReason(Short.valueOf((short)5));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object.c.close.TlvsBuilder().build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testLoadBalancingObject() throws IOException, PCEPDeserializerException {
        PCEPLoadBalancingObjectParser parser = new PCEPLoadBalancingObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLoadBalancingObject1.bin"));
        LoadBalancingBuilder builder = new LoadBalancingBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setMaxLsp(Short.valueOf((short)UnsignedBytes.toInt((byte)-15)));
        builder.setMinBandwidth(new Bandwidth(new byte[]{-1, -1, -1, -1}));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testERObject() throws Exception {
        PCEPExplicitRouteObjectParser parser = new PCEPExplicitRouteObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPExplicitRouteObject1PackOfSubobjects.bin"));
        EroBuilder builder = new EroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList subs = Lists.newArrayList();
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Long.valueOf(65535L))).build()).build()).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/32"))).build()).build()).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder().setRouterId(Long.valueOf(0xFFFFFFFFL)).setInterfaceId(Long.valueOf(0xFFFFFFFFL)).build()).build()).build());
        builder.setSubobject((List)subs);
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testIRObject() throws Exception {
        PCEPIncludeRouteObjectParser parser = new PCEPIncludeRouteObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPIncludeRouteObject1PackOfSubobjects.bin"));
        byte[] ip6PrefixBytes = new byte[]{18, 52, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IroBuilder builder = new IroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList subs = Lists.newArrayList();
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Long.valueOf(16L))).build()).build()).setLoose(Boolean.valueOf(true)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("18.52.80.0/21"))).build()).build()).setLoose(Boolean.valueOf(true)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(Ipv6Util.prefixForBytes((byte[])ip6PrefixBytes, (int)22))).build()).build()).setLoose(Boolean.valueOf(true)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder().setRouterId(Long.valueOf(19158648L)).setInterfaceId(Long.valueOf(2596069104L)).build()).build()).setLoose(Boolean.valueOf(true)).build());
        builder.setSubobject((List)subs);
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testRRObject() throws Exception {
        PCEPReportedRouteObjectParser parser = new PCEPReportedRouteObjectParser(this.ctx.getRROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPReportedRouteObject1PackOfSubobjects.bin"));
        byte[] ip6PrefixBytes = new byte[]{18, 52, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        RroBuilder builder = new RroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList subs = Lists.newArrayList();
        subs.add(new SubobjectBuilder().setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/32"))).build()).build()).setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(false)).build());
        subs.add(new SubobjectBuilder().setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder().setIpPrefix(new IpPrefix(Ipv6Util.prefixForBytes((byte[])ip6PrefixBytes, (int)22))).build()).build()).setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(false)).build());
        subs.add(new SubobjectBuilder().setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.UnnumberedCaseBuilder().setUnnumbered(new UnnumberedBuilder().setRouterId(Long.valueOf(19158648L)).setInterfaceId(Long.valueOf(2596069104L)).build()).build()).setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(false)).build());
        builder.setSubobject((List)subs);
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testBandwidthObject() throws IOException, PCEPDeserializerException {
        PCEPBandwidthObjectParser parser = new PCEPBandwidthObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPBandwidthObject1LowerBounds.bin"));
        BandwidthBuilder builder = new BandwidthBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setBandwidth(new Bandwidth(new byte[]{0, 0, 0, 0}));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testExistingBandwidthObject() throws IOException, PCEPDeserializerException {
        PCEPExistingBandwidthObjectParser parser = new PCEPExistingBandwidthObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPBandwidthObject2UpperBounds.bin"));
        ReoptimizationBandwidthBuilder builder = new ReoptimizationBandwidthBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setBandwidth(new Bandwidth(new byte[]{-1, -1, -1, -1}));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testEndPointsObjectIPv4() throws IOException, PCEPDeserializerException {
        byte[] srcIPBytes = new byte[]{-94, -11, 17, 14};
        byte[] destIPBytes = new byte[]{-1, -1, -1, -1};
        PCEPEndPointsIpv4ObjectParser parser = new PCEPEndPointsIpv4ObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPEndPointsObject1IPv4.bin"));
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setAddressFamily((AddressFamily)new Ipv4CaseBuilder().setIpv4(new Ipv4Builder().setSourceIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])srcIPBytes))).setDestinationIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])destIPBytes))).build()).build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testEndPointsObjectIPv6() throws IOException, PCEPDeserializerException {
        byte[] destIPBytes = new byte[]{0, 2, 93, -46, -1, -20, -95, -74, 88, 30, -97, 80, 0, 0, 0, 0};
        byte[] srcIPBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        PCEPEndPointsIpv6ObjectParser parser = new PCEPEndPointsIpv6ObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPEndPointsObject2IPv6.bin"));
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setAddressFamily((AddressFamily)new Ipv6CaseBuilder().setIpv6(new Ipv6Builder().setSourceIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])srcIPBytes))).setDestinationIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])destIPBytes))).build()).build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        PCEPEndPointsIpv6ObjectParser.serializeObject((Object)builder.build(), (ByteBuf)buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testErrorObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPErrorObjectParser parser = new PCEPErrorObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPErrorObject1.bin"));
        ErrorObjectBuilder builder = new ErrorObjectBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setType(Short.valueOf((short)1));
        builder.setValue(Short.valueOf((short)1));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPErrorObject3.bin"));
        builder.setType(Short.valueOf((short)7));
        builder.setValue(Short.valueOf((short)0));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object.TlvsBuilder().setReqMissing(new ReqMissingBuilder().setRequestId(new RequestId(Long.valueOf(4437L))).build()).build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testLspaObject() throws IOException, PCEPDeserializerException {
        PCEPLspaObjectParser parser = new PCEPLspaObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLspaObject1LowerBounds.bin"));
        LspaBuilder builder = new LspaBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setExcludeAny(new AttributeFilter(Long.valueOf(0L)));
        builder.setIncludeAny(new AttributeFilter(Long.valueOf(0L)));
        builder.setIncludeAll(new AttributeFilter(Long.valueOf(0L)));
        builder.setHoldPriority(Short.valueOf((short)0));
        builder.setSetupPriority(Short.valueOf((short)0));
        builder.setLocalProtectionDesired(Boolean.valueOf(false));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.lspa.TlvsBuilder().build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLspaObject2UpperBounds.bin"));
        builder.setExcludeAny(new AttributeFilter(Long.valueOf(0xFFFFFFFFL)));
        builder.setIncludeAny(new AttributeFilter(Long.valueOf(0xFFFFFFFFL)));
        builder.setIncludeAll(new AttributeFilter(Long.valueOf(0xFFFFFFFFL)));
        builder.setHoldPriority(Short.valueOf((short)255));
        builder.setSetupPriority(Short.valueOf((short)255));
        builder.setLocalProtectionDesired(Boolean.valueOf(true));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testMetricObject() throws IOException, PCEPDeserializerException {
        PCEPMetricObjectParser parser = new PCEPMetricObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPMetricObject1LowerBounds.bin"));
        MetricBuilder builder = new MetricBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setComputed(Boolean.valueOf(false));
        builder.setBound(Boolean.valueOf(false));
        builder.setMetricType(Short.valueOf((short)1));
        builder.setValue(new Float32(new byte[]{0, 0, 0, 0}));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPMetricObject2UpperBounds.bin"));
        builder.setComputed(Boolean.valueOf(true));
        builder.setBound(Boolean.valueOf(false));
        builder.setMetricType(Short.valueOf((short)2));
        builder.setValue(new Float32(new byte[]{79, 112, 0, 0}));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testNoPathObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPNoPathObjectParser parser = new PCEPNoPathObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNoPathObject1WithoutTLV.bin"));
        NoPathBuilder builder = new NoPathBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setNatureOfIssue(Short.valueOf((short)1));
        builder.setUnsatisfiedConstraints(Boolean.valueOf(true));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.TlvsBuilder().build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNoPathObject2WithTLV.bin"));
        builder.setNatureOfIssue(Short.valueOf((short)0));
        builder.setUnsatisfiedConstraints(Boolean.valueOf(false));
        NoPathVectorBuilder b = new NoPathVectorBuilder();
        b.setFlags(new NoPathVectorTlv.Flags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.TlvsBuilder().setNoPathVector(b.build()).build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testNotifyObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPNotificationObjectParser parser = new PCEPNotificationObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNotificationObject2WithoutTlv.bin"));
        CNotificationBuilder builder = new CNotificationBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setType(Short.valueOf((short)255));
        builder.setValue(Short.valueOf((short)255));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNotificationObject1WithTlv.bin"));
        builder.setType(Short.valueOf((short)2));
        builder.setValue(Short.valueOf((short)1));
        builder.setTlvs(new TlvsBuilder().setOverloadDuration(new OverloadDurationBuilder().setDuration(Long.valueOf(4278190242L)).build()).build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testRPObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPRequestParameterObjectParser parser = new PCEPRequestParameterObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPRPObject1.bin"));
        RpBuilder builder = new RpBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setReoptimization(Boolean.valueOf(true));
        builder.setBiDirectional(Boolean.valueOf(false));
        builder.setLoose(Boolean.valueOf(true));
        builder.setMakeBeforeBreak(Boolean.valueOf(true));
        builder.setOrder(Boolean.valueOf(false));
        builder.setPathKey(Boolean.valueOf(false));
        builder.setSupplyOf(Boolean.valueOf(false));
        builder.setFragmentation(Boolean.valueOf(false));
        builder.setP2mp(Boolean.valueOf(false));
        builder.setEroCompression(Boolean.valueOf(false));
        builder.setPriority(Short.valueOf((short)5));
        builder.setRequestId(new RequestId(Long.valueOf(3735928559L)));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.TlvsBuilder().build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPRPObject2.bin"));
        builder.setReoptimization(Boolean.valueOf(false));
        builder.setFragmentation(Boolean.valueOf(true));
        builder.setEroCompression(Boolean.valueOf(true));
        OrderBuilder b = new OrderBuilder();
        b.setDelete(Long.valueOf(0xFFFFFFFFL));
        b.setSetup(Long.valueOf(1L));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.TlvsBuilder().setOrder(b.build()).build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testSvecObject() throws IOException, PCEPDeserializerException {
        PCEPSvecObjectParser parser = new PCEPSvecObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPSvecObject2.bin"));
        SvecBuilder builder = new SvecBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setLinkDiverse(Boolean.valueOf(false));
        builder.setNodeDiverse(Boolean.valueOf(false));
        builder.setSrlgDiverse(Boolean.valueOf(false));
        builder.setRequestsIds((List)Lists.newArrayList((java.lang.Object[])new RequestId[]{new RequestId(Long.valueOf(255L))}));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPSvecObject1_10ReqIDs.bin"));
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setLinkDiverse(Boolean.valueOf(true));
        builder.setSrlgDiverse(Boolean.valueOf(true));
        ArrayList requestIDs = Lists.newArrayList();
        requestIDs.add(new RequestId(Long.valueOf(0xFFFFFFFFL)));
        requestIDs.add(new RequestId(Long.valueOf(1L)));
        requestIDs.add(new RequestId(Long.valueOf(19088743L)));
        requestIDs.add(new RequestId(Long.valueOf(2309737967L)));
        requestIDs.add(new RequestId(Long.valueOf(4275878552L)));
        requestIDs.add(new RequestId(Long.valueOf(1985229328L)));
        requestIDs.add(new RequestId(Long.valueOf(360862310L)));
        requestIDs.add(new RequestId(Long.valueOf(1209142206L)));
        requestIDs.add(new RequestId(Long.valueOf(637238866L)));
        requestIDs.add(new RequestId(Long.valueOf(3002225771L)));
        builder.setRequestsIds((List)requestIDs);
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testClassTypeObject() throws PCEPDeserializerException {
        PCEPClassTypeObjectParser parser = new PCEPClassTypeObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])new byte[]{22, 18, 0, 8, 0, 0, 0, 4});
        ClassTypeBuilder builder = new ClassTypeBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setClassType(new ClassType(Short.valueOf((short)4)));
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testExcludeRouteObject() throws Exception {
        PCEPExcludeRouteObjectParser parser = new PCEPExcludeRouteObjectParser(this.ctx.getXROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPExcludeRouteObject.1.bin"));
        XroBuilder builder = new XroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setFlags(new Xro.Flags(Boolean.valueOf(true)));
        ArrayList subs = Lists.newArrayList();
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.SubobjectBuilder().setMandatory(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("192.168.0.0/16"))).build()).build()).setAttribute(ExcludeRouteSubobjects.Attribute.Node).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.SubobjectBuilder().setMandatory(Boolean.valueOf(false)).setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Long.valueOf(4660L))).build()).build()).build());
        builder.setSubobject((List)subs);
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testPathKeyObject() throws Exception {
        PCEPPathKeyObjectParser parser = new PCEPPathKeyObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPPathKeyObject.bin"));
        PathKeyBuilder builder = new PathKeyBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList list = Lists.newArrayList();
        list.add(new PathKeysBuilder().setLoose(Boolean.valueOf(true)).setPathKey(new PathKey(Integer.valueOf(4660))).setPceId(new PceId(new byte[]{18, 52, 80, 0})).build());
        builder.setPathKeys((List)list);
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testObjectiveFunctionObject() throws IOException, PCEPDeserializerException {
        PCEPObjectiveFunctionObjectParser parser = new PCEPObjectiveFunctionObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPObjectiveFunctionObject.1.bin"));
        OfBuilder builder = new OfBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setCode(new OfId(Integer.valueOf(4)));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.of.TlvsBuilder().build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testGlobalConstraintsObject() throws IOException, PCEPDeserializerException {
        PCEPGlobalConstraintsObjectParser parser = new PCEPGlobalConstraintsObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPGlobalConstraintsObject.1.bin"));
        GcBuilder builder = new GcBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setMaxHop(Short.valueOf((short)1));
        builder.setMaxUtilization(Short.valueOf((short)0));
        builder.setMinUtilization(Short.valueOf((short)100));
        builder.setOverBookingFactor(Short.valueOf((short)99));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.gc.TlvsBuilder().build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.", (java.lang.Object)e.getMessage());
        }
    }

    @Test
    public void testIgnoreUknownObject() throws PCEPDeserializerException {
        Object object = this.ctx.getObjectHandlerRegistry().parseObject(35, 1, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), null);
        Assert.assertNull((java.lang.Object)object);
    }

    @Test
    public void testUnrecognizedObjectType() throws PCEPDeserializerException {
        Object object = this.ctx.getObjectHandlerRegistry().parseObject(2, 2, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
        Assert.assertNotNull((java.lang.Object)object);
        Assert.assertTrue((boolean)(object instanceof UnknownObject));
        Assert.assertEquals((java.lang.Object)PCEPErrors.UNRECOGNIZED_OBJ_TYPE, (java.lang.Object)((UnknownObject)object).getError());
    }

    @Test
    public void testUnrecognizedObjectClass() throws PCEPDeserializerException {
        Object object = this.ctx.getObjectHandlerRegistry().parseObject(35, 1, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
        Assert.assertNotNull((java.lang.Object)object);
        Assert.assertTrue((boolean)(object instanceof UnknownObject));
        Assert.assertEquals((java.lang.Object)PCEPErrors.UNRECOGNIZED_OBJ_CLASS, (java.lang.Object)((UnknownObject)object).getError());
    }

    @Test
    public void testLspaObjectSerializerDefence() throws IOException, PCEPDeserializerException {
        PCEPLspaObjectParser parser = new PCEPLspaObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLspaObject1LowerBounds.bin"));
        LspaBuilder builder = new LspaBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setLocalProtectionDesired(Boolean.valueOf(false));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }

    @Test
    public void testEmptyEroObject() throws PCEPDeserializerException {
        Object object = this.ctx.getObjectHandlerRegistry().parseObject(7, 1, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
        Assert.assertNotNull((java.lang.Object)object);
        Assert.assertTrue((boolean)(object instanceof Ero));
        Ero eroObject = (Ero)object;
        Assert.assertTrue((boolean)eroObject.getSubobject().isEmpty());
        ByteBuf buffer = Unpooled.buffer();
        this.ctx.getObjectHandlerRegistry().serializeObject((Object)eroObject, buffer);
        byte[] expected = new byte[]{7, 19, 0, 4};
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testCloseObjectWithVendorInformationTlv() throws IOException, PCEPDeserializerException {
        byte[] closeBytes = new byte[]{15, 16, 0, 20, 0, 0, 0, 5, 0, 7, 0, 8, 0, 0, 0, 0, 0, 0, 0, 5};
        PCEPCloseObjectParser parser = new PCEPCloseObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])closeBytes);
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationTlv viTlv = new VendorInformationTlvBuilder().setEnterpriseNumber(new EnterpriseNumber(Long.valueOf(0L))).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        CCloseBuilder builder = new CCloseBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setReason(Short.valueOf((short)5));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object.c.close.TlvsBuilder().setVendorInformationTlv((List)Lists.newArrayList((java.lang.Object[])new VendorInformationTlv[]{viTlv})).build());
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }

    @Test
    public void testVendorInformationObject() throws PCEPDeserializerException {
        byte[] viObjBytes = new byte[]{34, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 5};
        TestVendorInformationObjectParser parser = new TestVendorInformationObjectParser();
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationObject viObj = new VendorInformationObjectBuilder().setEnterpriseNumber(new EnterpriseNumber(Long.valueOf(0L))).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])viObjBytes);
        result.readerIndex(8);
        VendorInformationObject o = (VendorInformationObject)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.readSlice(result.readableBytes()));
        Assert.assertEquals((java.lang.Object)viObj, (java.lang.Object)o);
        ByteBuf buf = Unpooled.buffer((int)viObjBytes.length);
        parser.serializeObject((Object)viObj, buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }

    @Test
    public void testMonitoringObject() throws PCEPDeserializerException {
        byte[] monitoringBytes = new byte[]{19, 16, 0, 12, 0, 0, 0, 1, 0, 0, 0, 16};
        PCEPMonitoringObjectParser parser = new PCEPMonitoringObjectParser(this.tlvRegistry, this.viTlvRegistry);
        Monitoring monitoring = new MonitoringBuilder().setMonitoringId(Long.valueOf(16L)).setFlags(new Monitoring.Flags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false))).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.monitoring.TlvsBuilder().build()).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])monitoringBytes);
        Assert.assertEquals((java.lang.Object)monitoring, (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)monitoringBytes.length);
        parser.serializeObject((Object)monitoring, buf);
        Assert.assertArrayEquals((byte[])monitoringBytes, (byte[])buf.array());
    }

    @Test
    public void testPccIdReqIPv4Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{20, 16, 0, 8, 127, 0, 0, 1};
        PCEPPccIdReqIPv4ObjectParser parser = new PCEPPccIdReqIPv4ObjectParser();
        PccIdReq pccIdReq = new PccIdReqBuilder().setIpAddress(new IpAddress(new Ipv4Address("127.0.0.1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((java.lang.Object)pccIdReq, (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((Object)pccIdReq, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testPccIdReqIPv6Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{20, 32, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        PCEPPccIdReqIPv6ObjectParser parser = new PCEPPccIdReqIPv6ObjectParser();
        PccIdReq pccIdReq = new PccIdReqBuilder().setIpAddress(new IpAddress(new Ipv6Address("::1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((java.lang.Object)pccIdReq, (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((Object)pccIdReq, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testPceIdIPv4Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{25, 16, 0, 8, 127, 0, 0, 1};
        PCEPPceIdIPv4ObjectParser parser = new PCEPPceIdIPv4ObjectParser();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId pceId = new PceIdBuilder().setIpAddress(new IpAddress(new Ipv4Address("127.0.0.1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((java.lang.Object)pceId, (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((Object)pceId, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testPceIdIPv6Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{25, 32, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        PCEPPceIdIPv6ObjectParser parser = new PCEPPceIdIPv6ObjectParser();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId pccIdReq = new PceIdBuilder().setIpAddress(new IpAddress(new Ipv6Address("::1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((java.lang.Object)pccIdReq, (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((Object)pccIdReq, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testProcTimeObject() throws PCEPDeserializerException {
        byte[] proctimeBytes = new byte[]{26, 16, 0, 28, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 5};
        PCEPProcTimeObjectParser parser = new PCEPProcTimeObjectParser();
        ProcTime procTime = new ProcTimeBuilder().setEstimated(Boolean.valueOf(true)).setAverageProcTime(Long.valueOf(4L)).setCurrentProcTime(Long.valueOf(1L)).setMaxProcTime(Long.valueOf(3L)).setMinProcTime(Long.valueOf(2L)).setVarianceProcTime(Long.valueOf(5L)).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])proctimeBytes);
        Assert.assertEquals((java.lang.Object)procTime, (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)proctimeBytes.length);
        parser.serializeObject((Object)procTime, buf);
        Assert.assertArrayEquals((byte[])proctimeBytes, (byte[])buf.array());
    }

    @Test
    public void testOverloadObject() throws PCEPDeserializerException {
        byte[] overloadBytes = new byte[]{27, 16, 0, 8, 0, 0, 0, 120};
        PCEPOverloadObjectParser parser = new PCEPOverloadObjectParser();
        Overload overload = new OverloadBuilder().setDuration(Integer.valueOf(120)).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])overloadBytes);
        Assert.assertEquals((java.lang.Object)overload, (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)overloadBytes.length);
        parser.serializeObject((Object)overload, buf);
        Assert.assertArrayEquals((byte[])overloadBytes, (byte[])buf.array());
    }

    @Test
    public void testRpObjectWithPstTlvParser() throws PCEPDeserializerException {
        byte[] rpObjectWithPstTlvBytes = new byte[]{2, 16, 0, 20, 0, 0, 4, 45, -34, -83, -66, -17, 0, 28, 0, 4, 0, 0, 0, 0};
        PCEPRequestParameterObjectParser parser = new PCEPRequestParameterObjectParser(this.tlvRegistry, this.viTlvRegistry);
        RpBuilder builder = new RpBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setReoptimization(Boolean.valueOf(true));
        builder.setBiDirectional(Boolean.valueOf(false));
        builder.setLoose(Boolean.valueOf(true));
        builder.setMakeBeforeBreak(Boolean.valueOf(true));
        builder.setOrder(Boolean.valueOf(false));
        builder.setPathKey(Boolean.valueOf(false));
        builder.setSupplyOf(Boolean.valueOf(false));
        builder.setFragmentation(Boolean.valueOf(false));
        builder.setP2mp(Boolean.valueOf(false));
        builder.setEroCompression(Boolean.valueOf(false));
        builder.setPriority(Short.valueOf((short)5));
        builder.setRequestId(new RequestId(Long.valueOf(3735928559L)));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.TlvsBuilder().setPathSetupType(new PathSetupTypeBuilder().setPst(Short.valueOf((short)0)).build()).build());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])rpObjectWithPstTlvBytes);
        Assert.assertEquals((java.lang.Object)builder.build(), (java.lang.Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])rpObjectWithPstTlvBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }
}

