/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.PCEPByteToMessageDecoder;
import org.opendaylight.protocol.pcep.impl.PCEPHandlerFactory;
import org.opendaylight.protocol.pcep.impl.PCEPMessageHeaderDecoder;
import org.opendaylight.protocol.pcep.impl.PCEPMessageToByteEncoder;
import org.opendaylight.protocol.pcep.spi.MessageRegistry;
import org.opendaylight.protocol.pcep.spi.pojo.ServiceLoaderPCEPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Close;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.keepalive.message.KeepaliveMessageBuilder;

public class PCEPParserTest {
    private final MessageRegistry registry = ServiceLoaderPCEPExtensionProviderContext.getSingletonInstance().getMessageHandlerRegistry();

    @Test
    public void testMessageToByteEncoding() {
        PCEPMessageToByteEncoder encoder = new PCEPMessageToByteEncoder(this.registry);
        ByteBuf out = Unpooled.buffer();
        encoder.encode(null, (Message)new KeepaliveBuilder().setKeepaliveMessage(new KeepaliveMessageBuilder().build()).build(), out);
        Assert.assertArrayEquals((byte[])new byte[]{32, 2, 0, 4}, (byte[])ByteArray.readAllBytes((ByteBuf)out));
    }

    @Test
    public void testByteToMessageEncoding() throws Exception {
        PCEPByteToMessageDecoder decoder = new PCEPByteToMessageDecoder(this.registry);
        ArrayList out = new ArrayList();
        decoder.decode(null, Unpooled.wrappedBuffer((byte[])new byte[]{32, 2, 0, 4}), out);
        Assert.assertTrue((boolean)(out.get(0) instanceof Keepalive));
        decoder.decode(null, Unpooled.wrappedBuffer((byte[])new byte[]{32, 7, 0, 12, 15, 16, 0, 8, 0, 0, 0, 5}), out);
        Assert.assertTrue((boolean)(out.get(1) instanceof Close));
        decoder.decode(null, Unpooled.wrappedBuffer((byte[])new byte[]{32, 6, 0, 24, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 13, 16, 0, 8, 0, 0, 24, 2}), out);
        Assert.assertTrue((boolean)(out.get(2) instanceof Pcerr));
    }

    @Test
    public void testHandlerFactory() {
        PCEPHandlerFactory handlers = new PCEPHandlerFactory(this.registry);
        Assert.assertEquals((long)1L, (long)handlers.getEncoders().length);
        Assert.assertTrue((boolean)(handlers.getEncoders()[0] instanceof PCEPMessageToByteEncoder));
        Assert.assertEquals((long)2L, (long)handlers.getDecoders().length);
        Assert.assertTrue((boolean)(handlers.getDecoders()[0] instanceof PCEPMessageHeaderDecoder));
        Assert.assertTrue((boolean)(handlers.getDecoders()[1] instanceof PCEPByteToMessageDecoder));
    }
}

