/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.Channel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.TerminationReason;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionTest;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.impl.SimpleSessionListener;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcreq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.CloseMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;

public class PCEPSessionImplTest
extends AbstractPCEPSessionTest {
    private PCEPSessionImpl session;

    @Before
    public void setup() {
        this.session = new PCEPSessionImpl((PCEPSessionListener)this.listener, 0, this.channel, this.openMsg.getOpenMessage().getOpen(), this.openMsg.getOpenMessage().getOpen());
        this.session.sessionUp();
    }

    @After
    public void tearDown() {
        this.session.close();
    }

    @Test
    public void testPcepSessionImpl() throws InterruptedException {
        Assert.assertTrue((boolean)this.listener.up);
        this.session.handleMessage((Message)this.kaMsg);
        Assert.assertEquals((long)1L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        this.session.handleMessage((Message)new PcreqBuilder().build());
        Assert.assertEquals((long)2L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)this.listener.messages.size());
        Assert.assertTrue((boolean)(this.listener.messages.get(0) instanceof Pcreq));
        Assert.assertEquals((long)2L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        this.session.handleMessage((Message)this.closeMsg);
        Assert.assertEquals((long)3L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)this.listener.messages.size());
        Assert.assertTrue((boolean)this.channel.isActive());
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testAttemptSecondSession() {
        this.session.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)1L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Pcerr));
        Pcerr pcErr = (Pcerr)this.msgsSend.get(0);
        ErrorObject errorObj = ((Errors)pcErr.getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((Object)PCEPErrors.ATTEMPT_2ND_SESSION, (Object)PCEPErrors.forValue((short)errorObj.getType(), (short)errorObj.getValue()));
    }

    @Test
    public void testClosedByNode() {
        this.session.handleMessage((Message)this.closeMsg);
        ((Channel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    public void testCapabilityNotSupported() {
        this.session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Pcerr));
        Pcerr pcErr = (Pcerr)this.msgsSend.get(0);
        ErrorObject errorObj = ((Errors)pcErr.getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((Object)PCEPErrors.CAPABILITY_NOT_SUPPORTED, (Object)PCEPErrors.forValue((short)errorObj.getType(), (short)errorObj.getValue()));
        Assert.assertEquals((long)1L, (long)this.session.getMessages().getUnknownMsgReceived().intValue());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof CloseMessage));
        CloseMessage closeMsg = (CloseMessage)this.msgsSend.get(1);
        Assert.assertEquals((Object)TerminationReason.TOO_MANY_UNKNOWN_MSGS, (Object)TerminationReason.forValue((short)closeMsg.getCCloseMessage().getCClose().getReason()));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testEndoOfInput() {
        Assert.assertTrue((boolean)this.listener.up);
        this.session.endOfInput();
        Assert.assertFalse((boolean)this.listener.up);
    }

    @Test
    public void testCloseSessionWithReason() {
        this.session.close(TerminationReason.UNKNOWN);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof CloseMessage));
        CloseMessage closeMsg = (CloseMessage)this.msgsSend.get(0);
        Assert.assertEquals((Object)TerminationReason.UNKNOWN, (Object)TerminationReason.forValue((short)closeMsg.getCCloseMessage().getCClose().getReason()));
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testSessionStatistics() {
        this.session.handleMessage(Util.createErrorMessage((PCEPErrors)PCEPErrors.LSP_RSVP_ERROR, null));
        Assert.assertEquals((Object)this.ipAddress, (Object)this.session.getPeerPref().getIpAddress());
        PeerPref peerPref = this.session.getPeerPref();
        Assert.assertEquals((Object)this.ipAddress, (Object)peerPref.getIpAddress());
        Assert.assertEquals((long)40L, (long)peerPref.getDeadtimer().shortValue());
        Assert.assertEquals((long)15L, (long)peerPref.getKeepalive().shortValue());
        Assert.assertEquals((long)0L, (long)peerPref.getSessionId().intValue());
        LocalPref localPref = this.session.getLocalPref();
        Assert.assertEquals((Object)this.ipAddress, (Object)localPref.getIpAddress());
        Assert.assertEquals((long)40L, (long)localPref.getDeadtimer().shortValue());
        Assert.assertEquals((long)15L, (long)localPref.getKeepalive().shortValue());
        Assert.assertEquals((long)0L, (long)localPref.getSessionId().intValue());
        Messages msgs = this.session.getMessages();
        Assert.assertEquals((long)1L, (long)msgs.getReceivedMsgCount());
        Assert.assertEquals((long)0L, (long)msgs.getSentMsgCount());
        Assert.assertEquals((long)0L, (long)msgs.getUnknownMsgReceived().longValue());
        ErrorMessages errMsgs = msgs.getErrorMessages();
        Assert.assertEquals((long)1L, (long)errMsgs.getReceivedErrorMsgCount().intValue());
        Assert.assertEquals((long)0L, (long)errMsgs.getSentErrorMsgCount().intValue());
        Assert.assertEquals((long)PCEPErrors.LSP_RSVP_ERROR.getErrorType(), (long)errMsgs.getLastReceivedError().getErrorType().shortValue());
        Assert.assertEquals((long)PCEPErrors.LSP_RSVP_ERROR.getErrorValue(), (long)errMsgs.getLastReceivedError().getErrorValue().shortValue());
        this.session.sendMessage(Util.createErrorMessage((PCEPErrors)PCEPErrors.UNKNOWN_PLSP_ID, null));
        Messages msgs2 = this.session.getMessages();
        Assert.assertEquals((long)1L, (long)msgs2.getReceivedMsgCount());
        Assert.assertEquals((long)1L, (long)msgs2.getSentMsgCount());
        Assert.assertEquals((long)0L, (long)msgs2.getUnknownMsgReceived().longValue());
        ErrorMessages errMsgs2 = msgs2.getErrorMessages();
        Assert.assertEquals((long)1L, (long)errMsgs2.getReceivedErrorMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)errMsgs2.getSentErrorMsgCount().intValue());
        Assert.assertEquals((long)PCEPErrors.UNKNOWN_PLSP_ID.getErrorType(), (long)errMsgs2.getLastSentError().getErrorType().shortValue());
        Assert.assertEquals((long)PCEPErrors.UNKNOWN_PLSP_ID.getErrorValue(), (long)errMsgs2.getLastSentError().getErrorValue().shortValue());
    }

    @Test
    public void testExceptionCaught() throws Exception {
        Assert.assertFalse((boolean)this.session.isClosed());
        Assert.assertTrue((boolean)this.listener.up);
        this.session.exceptionCaught(null, new Throwable("PCEP exception."));
        Assert.assertFalse((boolean)this.listener.up);
        Assert.assertTrue((boolean)this.session.isClosed());
    }

    @Test
    public void testSessionRecoveryOnException() throws Exception {
        this.listener = new SimpleExceptionSessionListener();
        this.session = (PCEPSessionImpl)Mockito.spy((Object)new PCEPSessionImpl((PCEPSessionListener)this.listener, 0, this.channel, this.openMsg.getOpenMessage().getOpen(), this.openMsg.getOpenMessage().getOpen()));
        ((PCEPSessionImpl)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).handleException((Throwable)Matchers.any());
        ((PCEPSessionImpl)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).sendMessage((Message)Matchers.any());
        ((PCEPSessionImpl)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).closeChannel();
        try {
            this.session.sessionUp();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.listener.up);
        ((PCEPSessionImpl)Mockito.verify((Object)this.session)).handleException((Throwable)Matchers.any());
        ((PCEPSessionImpl)Mockito.verify((Object)this.session)).sendMessage((Message)Matchers.any(CloseMessage.class));
        ((PCEPSessionImpl)Mockito.verify((Object)this.session)).closeChannel();
    }

    private static class SimpleExceptionSessionListener
    extends SimpleSessionListener {
        private SimpleExceptionSessionListener() {
        }

        @Override
        public synchronized void onSessionUp(PCEPSession session) {
            super.onSessionUp(session);
            throw new RuntimeException("Mocked runtime exception.");
        }
    }
}

