/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.NoPathVectorTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.OFListTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.OrderTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.OverloadedDurationTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.PathSetupTypeTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.ReqMissingTlvParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathVectorTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.list.tlv.OfList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.list.tlv.OfListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.OrderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.duration.tlv.OverloadDurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.req.missing.tlv.ReqMissing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.req.missing.tlv.ReqMissingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlvBuilder;

public class PCEPTlvParserTest {
    private static final byte[] noPathVectorBytes = new byte[]{0, 1, 0, 4, 0, 0, 0, -89};
    private static final byte[] overloadedBytes = new byte[]{0, 2, 0, 4, 127, -1, -1, -1};
    private static final byte[] reqMissingBytes = new byte[]{0, 3, 0, 4, -9, -126, 53, 23};
    private static final byte[] orderBytes = new byte[]{0, 5, 0, 8, -1, -1, -1, -1, 0, 0, 0, 1};
    private static final byte[] ofListBytes = new byte[]{0, 4, 0, 4, 18, 52, 86, 120};
    private static final byte[] VENDOR_INFO_BYTES = new byte[]{0, 7, 0, 8, 0, 0, 0, 0, 0, 0, 0, 5};
    private static final byte[] PST_TLV_BYTES = new byte[]{0, 28, 0, 4, 0, 0, 0, 0};
    private static final byte[] PST_TLV_BYTES_UNSUPPORTED = new byte[]{0, 28, 0, 4, 0, 0, 0, 1};

    @Test
    public void testNoPathVectorTlv() throws PCEPDeserializerException {
        NoPathVectorTlvParser parser = new NoPathVectorTlvParser();
        NoPathVector tlv = new NoPathVectorBuilder().setFlags(new NoPathVectorTlv.Flags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true))).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])noPathVectorBytes, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])noPathVectorBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testOverloadedDurationTlv() throws PCEPDeserializerException {
        OverloadedDurationTlvParser parser = new OverloadedDurationTlvParser();
        OverloadDuration tlv = new OverloadDurationBuilder().setDuration(Long.valueOf(Integer.MAX_VALUE)).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])overloadedBytes, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])overloadedBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testReqMissingTlv() throws PCEPDeserializerException {
        ReqMissingTlvParser parser = new ReqMissingTlvParser();
        ReqMissing tlv = new ReqMissingBuilder().setRequestId(new RequestId(Long.valueOf(4152505623L))).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])reqMissingBytes, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])reqMissingBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testOrderTlv() throws PCEPDeserializerException {
        OrderTlvParser parser = new OrderTlvParser();
        Order tlv = new OrderBuilder().setDelete(Long.valueOf(0xFFFFFFFFL)).setSetup(Long.valueOf(1L)).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])orderBytes, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])orderBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testOFListTlv() throws PCEPDeserializerException {
        OFListTlvParser parser = new OFListTlvParser();
        ArrayList ids = Lists.newArrayList();
        ids.add(new OfId(Integer.valueOf(4660)));
        ids.add(new OfId(Integer.valueOf(22136)));
        OfList tlv = new OfListBuilder().setCodes((List)ids).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])ofListBytes, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])ofListBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testVendorInformationTlv() throws PCEPDeserializerException {
        TestVendorInformationTlvParser parser = new TestVendorInformationTlvParser();
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationTlv viTlv = new VendorInformationTlvBuilder().setEnterpriseNumber(new EnterpriseNumber(Long.valueOf(0L))).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        VendorInformationTlv parsedTlv = parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])VENDOR_INFO_BYTES, (int)8)));
        Assert.assertEquals((Object)viTlv, (Object)parsedTlv);
        ByteBuf buff = Unpooled.buffer((int)VENDOR_INFO_BYTES.length);
        parser.serializeTlv((Tlv)viTlv, buff);
        Assert.assertArrayEquals((byte[])VENDOR_INFO_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testPathSetupTypeTlvParser() throws PCEPDeserializerException {
        PathSetupTypeTlvParser parser = new PathSetupTypeTlvParser();
        PathSetupType pstTlv = new PathSetupTypeBuilder().setPst(Short.valueOf((short)0)).build();
        Assert.assertEquals((Object)pstTlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PST_TLV_BYTES, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)pstTlv, buff);
        Assert.assertArrayEquals((byte[])PST_TLV_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
    }

    @Test(expected=PCEPDeserializerException.class)
    public void testUnsupportedPSTParser() throws PCEPDeserializerException {
        PathSetupTypeTlvParser parser = new PathSetupTypeTlvParser();
        parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PST_TLV_BYTES_UNSUPPORTED, (int)4)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedPSTSerializer() {
        PathSetupTypeTlvParser parser = new PathSetupTypeTlvParser();
        PathSetupType pstTlv = new PathSetupTypeBuilder().setPst(Short.valueOf((short)1)).build();
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)pstTlv, buff);
    }
}

