/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationActivator;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationTlvParser;
import org.opendaylight.protocol.pcep.parser.BaseParserExtensionActivator;
import org.opendaylight.protocol.pcep.parser.message.PCEPCloseMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPErrorMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPKeepAliveMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPMonitoringReplyMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPMonitoringRequestMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPNotificationMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPOpenMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPReplyMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPRequestMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPStartTLSMessageParser;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.pojo.SimplePCEPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.CloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcmonrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcmonreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcntfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.StarttlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object.CCloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.Ipv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv4._case.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.EroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.IroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.keepalive.message.KeepaliveMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.MetricBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.metrics.MetricPceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.MonitoringBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.MonitoringMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.monitoring.metrics.list.GeneralMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.monitoring.metrics.list.SpecificMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.OfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.object.OverloadBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.RequestCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.SessionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.RequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.session._case.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcmonrep.message.PcmonrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.NotificationsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.PcrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.RepliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.Result;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.FailureCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.SuccessCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.NoPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.SuccessBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.PathsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.PcreqMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.MonitoringRequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.RequestsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.monitoring.request.PceIdList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.monitoring.request.PceIdListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.SegmentComputationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2pBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTimeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.RpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.start.tls.message.StartTlsMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.SvecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder;

public class PCEPValidatorTest {
    private ObjectRegistry objectRegistry;
    private Open open;
    private Rp rpTrue;
    private Rp rpFalse;
    private NoPath noPath;
    private Lspa lspa;
    private Metrics metrics;
    private Iro iro;
    private Ero ero;
    private Of of;
    private EndpointsObj endpoints;
    private Svec svec;
    private List<VendorInformationObject> viObjects;
    private Monitoring monitoring;
    private PccIdReq pccIdReq;
    private PceId pceId;
    private ProcTime procTime;
    private Overload overload;
    private AsNumberCase eroASSubobject;
    private SimplePCEPExtensionProviderContext ctx;
    private BaseParserExtensionActivator act;
    private TestVendorInformationActivator viObjAct;

    @Before
    public void setUp() throws Exception {
        this.ctx = new SimplePCEPExtensionProviderContext();
        this.act = new BaseParserExtensionActivator();
        this.viObjAct = new TestVendorInformationActivator();
        this.act.start((PCEPExtensionProviderContext)this.ctx);
        this.viObjAct.start((PCEPExtensionProviderContext)this.ctx);
        this.objectRegistry = this.ctx.getObjectHandlerRegistry();
        RpBuilder rpBuilder = new RpBuilder();
        rpBuilder.setProcessingRule(Boolean.valueOf(true));
        rpBuilder.setIgnore(Boolean.valueOf(false));
        rpBuilder.setReoptimization(Boolean.valueOf(false));
        rpBuilder.setBiDirectional(Boolean.valueOf(false));
        rpBuilder.setLoose(Boolean.valueOf(true));
        rpBuilder.setMakeBeforeBreak(Boolean.valueOf(false));
        rpBuilder.setOrder(Boolean.valueOf(false));
        rpBuilder.setPathKey(Boolean.valueOf(false));
        rpBuilder.setSupplyOf(Boolean.valueOf(false));
        rpBuilder.setFragmentation(Boolean.valueOf(false));
        rpBuilder.setP2mp(Boolean.valueOf(false));
        rpBuilder.setEroCompression(Boolean.valueOf(false));
        rpBuilder.setPriority(Short.valueOf((short)1));
        rpBuilder.setRequestId(new RequestId(Long.valueOf(10L)));
        rpBuilder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.TlvsBuilder().build());
        this.rpTrue = rpBuilder.build();
        rpBuilder.setProcessingRule(Boolean.valueOf(false));
        this.rpFalse = rpBuilder.build();
        OpenBuilder openBuilder = new OpenBuilder();
        openBuilder.setProcessingRule(Boolean.valueOf(false));
        openBuilder.setIgnore(Boolean.valueOf(false));
        openBuilder.setDeadTimer(Short.valueOf((short)1));
        openBuilder.setKeepalive(Short.valueOf((short)1));
        openBuilder.setSessionId(Short.valueOf((short)0));
        openBuilder.setVersion(new ProtocolVersion(Short.valueOf((short)1)));
        openBuilder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder().build());
        this.open = openBuilder.build();
        NoPathBuilder npbuilder = new NoPathBuilder();
        npbuilder.setProcessingRule(Boolean.valueOf(false));
        npbuilder.setIgnore(Boolean.valueOf(false));
        npbuilder.setNatureOfIssue(Short.valueOf((short)0));
        npbuilder.setUnsatisfiedConstraints(Boolean.valueOf(false));
        npbuilder.setTlvs(new TlvsBuilder().build());
        this.noPath = npbuilder.build();
        LspaBuilder lspaBuilder = new LspaBuilder();
        lspaBuilder.setProcessingRule(Boolean.valueOf(false));
        lspaBuilder.setIgnore(Boolean.valueOf(false));
        lspaBuilder.setLocalProtectionDesired(Boolean.valueOf(false));
        lspaBuilder.setHoldPriority(Short.valueOf((short)0));
        lspaBuilder.setSetupPriority(Short.valueOf((short)0));
        lspaBuilder.setExcludeAny(new AttributeFilter(Long.valueOf(0L)));
        lspaBuilder.setIncludeAll(new AttributeFilter(Long.valueOf(0L)));
        lspaBuilder.setIncludeAny(new AttributeFilter(Long.valueOf(0L)));
        lspaBuilder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.lspa.TlvsBuilder().build());
        this.lspa = lspaBuilder.build();
        MetricBuilder mBuilder = new MetricBuilder();
        mBuilder.setIgnore(Boolean.valueOf(false));
        mBuilder.setProcessingRule(Boolean.valueOf(false));
        mBuilder.setComputed(Boolean.valueOf(false));
        mBuilder.setBound(Boolean.valueOf(false));
        mBuilder.setMetricType(Short.valueOf((short)1));
        mBuilder.setValue(new Float32(new byte[4]));
        this.metrics = new MetricsBuilder().setMetric(mBuilder.build()).build();
        this.eroASSubobject = new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Long.valueOf(65535L))).build()).build();
        IroBuilder iroBuilder = new IroBuilder();
        iroBuilder.setIgnore(Boolean.valueOf(false));
        iroBuilder.setProcessingRule(Boolean.valueOf(false));
        ArrayList iroSubs = Lists.newArrayList();
        iroSubs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)this.eroASSubobject).setLoose(Boolean.valueOf(false)).build());
        iroBuilder.setSubobject((List)iroSubs);
        this.iro = iroBuilder.build();
        EroBuilder eroBuilder = new EroBuilder();
        eroBuilder.setIgnore(Boolean.valueOf(false));
        eroBuilder.setProcessingRule(Boolean.valueOf(false));
        ArrayList eroSubs = Lists.newArrayList();
        eroSubs.add(new SubobjectBuilder().setSubobjectType((SubobjectType)this.eroASSubobject).setLoose(Boolean.valueOf(false)).build());
        eroBuilder.setSubobject((List)eroSubs);
        this.ero = eroBuilder.build();
        OfBuilder ofBuilder = new OfBuilder();
        ofBuilder.setIgnore(Boolean.valueOf(false));
        ofBuilder.setProcessingRule(Boolean.valueOf(false));
        ofBuilder.setCode(new OfId(Integer.valueOf(0)));
        ofBuilder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.of.TlvsBuilder().build());
        this.of = ofBuilder.build();
        Ipv4Builder afi = new Ipv4Builder();
        afi.setSourceIpv4Address(new Ipv4Address("255.255.255.255"));
        afi.setDestinationIpv4Address(new Ipv4Address("255.255.255.255"));
        EndpointsObjBuilder epBuilder = new EndpointsObjBuilder();
        epBuilder.setIgnore(Boolean.valueOf(false));
        epBuilder.setProcessingRule(Boolean.valueOf(true));
        epBuilder.setAddressFamily((AddressFamily)new Ipv4CaseBuilder().setIpv4(afi.build()).build());
        this.endpoints = epBuilder.build();
        SvecBuilder sBuilder = new SvecBuilder();
        sBuilder.setIgnore(Boolean.valueOf(false));
        sBuilder.setProcessingRule(Boolean.valueOf(false));
        sBuilder.setLinkDiverse(Boolean.valueOf(false));
        sBuilder.setNodeDiverse(Boolean.valueOf(false));
        sBuilder.setSrlgDiverse(Boolean.valueOf(false));
        sBuilder.setRequestsIds((List)Lists.newArrayList((Object[])new RequestId[]{new RequestId(Long.valueOf(1L))}));
        this.svec = sBuilder.build();
        this.viObjects = Lists.newArrayList();
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationObject viObj = new VendorInformationObjectBuilder().setEnterpriseNumber(new EnterpriseNumber(Long.valueOf(0L))).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        this.viObjects.add(viObj);
        this.monitoring = new MonitoringBuilder().setMonitoringId(Long.valueOf(100L)).setFlags(new Monitoring.Flags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false))).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.monitoring.TlvsBuilder().build()).build();
        this.pccIdReq = new PccIdReqBuilder().setIpAddress(new IpAddress(new Ipv4Address("127.0.0.1"))).build();
        this.pceId = new PceIdBuilder().setIpAddress(new IpAddress(new Ipv4Address("127.0.0.2"))).build();
        ProcTimeBuilder procTimeBuilder = new ProcTimeBuilder();
        procTimeBuilder.setEstimated(Boolean.valueOf(false));
        procTimeBuilder.setCurrentProcTime(Long.valueOf(1L));
        procTimeBuilder.setMinProcTime(Long.valueOf(2L));
        procTimeBuilder.setMaxProcTime(Long.valueOf(3L));
        procTimeBuilder.setAverageProcTime(Long.valueOf(4L));
        procTimeBuilder.setVarianceProcTime(Long.valueOf(5L));
        this.procTime = procTimeBuilder.build();
        this.overload = new OverloadBuilder().setDuration(Integer.valueOf(120)).build();
    }

    @Test
    public void testOpenMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPOpenMessage1.bin"));
        PCEPOpenMessageParser parser = new PCEPOpenMessageParser(this.ctx.getObjectHandlerRegistry());
        OpenMessageBuilder builder = new OpenMessageBuilder();
        OpenBuilder b = new OpenBuilder();
        b.setProcessingRule(Boolean.valueOf(false));
        b.setIgnore(Boolean.valueOf(false));
        b.setVersion(new ProtocolVersion(Short.valueOf((short)1)));
        b.setKeepalive(Short.valueOf((short)30));
        b.setDeadTimer(Short.valueOf((short)120));
        b.setSessionId(Short.valueOf((short)1));
        b.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder().build());
        builder.setOpen(b.build());
        Assert.assertEquals((Object)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.OpenBuilder().setOpenMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.OpenBuilder().setOpenMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.OpenBuilder().setOpenMessage(new OpenMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Open Object must be present in Open Message.", (Object)e.getMessage());
        }
    }

    @Test
    public void testKeepAliveMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])new byte[]{32, 2, 0, 4});
        PCEPKeepAliveMessageParser parser = new PCEPKeepAliveMessageParser(this.objectRegistry);
        KeepaliveBuilder builder = new KeepaliveBuilder().setKeepaliveMessage(new KeepaliveMessageBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testStartTLSMsg() throws Exception {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])new byte[]{32, 20, 0, 4});
        PCEPStartTLSMessageParser parser = new PCEPStartTLSMessageParser(this.objectRegistry);
        StarttlsBuilder builder = new StarttlsBuilder().setStartTlsMessage(new StartTlsMessageBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testCloseMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPCloseMessage1.bin"));
        PCEPCloseMessageParser parser = new PCEPCloseMessageParser(this.objectRegistry);
        CloseBuilder builder = new CloseBuilder().setCCloseMessage(new CCloseMessageBuilder().setCClose(new CCloseBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setReason(Short.valueOf((short)5)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object.c.close.TlvsBuilder().build()).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new CloseBuilder().setCCloseMessage(new CCloseMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Close Object must be present in Close Message.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRequestMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPRequestMessage1.bin"));
        PCEPRequestMessageParser parser = new PCEPRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        ArrayList reqs1 = Lists.newArrayList();
        RequestsBuilder rBuilder = new RequestsBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setSegmentComputation(new SegmentComputationBuilder().setP2p(new P2pBuilder().setEndpointsObj(this.endpoints).build()).build());
        reqs1.add(rBuilder.build());
        builder.setRequests((List)reqs1);
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCReq.3.bin"));
        ArrayList reqs2 = Lists.newArrayList();
        RequestsBuilder rBuilder1 = new RequestsBuilder();
        rBuilder1.setRp(this.rpTrue);
        P2pBuilder p2pBuilder = new P2pBuilder();
        p2pBuilder.setEndpointsObj(this.endpoints);
        p2pBuilder.setMetrics((List)Lists.newArrayList((Object[])new Metrics[]{this.metrics}));
        p2pBuilder.setIro(this.iro);
        rBuilder1.setSegmentComputation(new SegmentComputationBuilder().setP2p(p2pBuilder.build()).build());
        reqs2.add(rBuilder1.build());
        builder.setRequests((List)reqs2);
        builder.setSvec((List)Lists.newArrayList((Object[])new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec[]{new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.SvecBuilder().setSvec(this.svec).build()}));
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(new PcreqMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Requests cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(new PcreqMessageBuilder().setRequests(Collections.emptyList()).build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Requests cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testReplyMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.1.bin"));
        PCEPReplyMessageParser parser = new PCEPReplyMessageParser(this.objectRegistry);
        PcrepMessageBuilder builder = new PcrepMessageBuilder();
        RepliesBuilder rBuilder = new RepliesBuilder();
        ArrayList replies1 = Lists.newArrayList();
        rBuilder.setRp(this.rpTrue);
        replies1.add(rBuilder.build());
        builder.setReplies((List)replies1);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.2.bin"));
        ArrayList replies2 = Lists.newArrayList();
        rBuilder = new RepliesBuilder();
        rBuilder.setRp(this.rpTrue);
        replies2.add(rBuilder.build());
        RepliesBuilder rBuilder2 = new RepliesBuilder();
        rBuilder2.setRp(this.rpTrue);
        rBuilder2.setResult((Result)new FailureCaseBuilder().setNoPath(this.noPath).build());
        replies2.add(rBuilder2.build());
        builder.setReplies((List)replies2);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.3.bin"));
        ArrayList replies3 = Lists.newArrayList();
        rBuilder = new RepliesBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setResult((Result)new FailureCaseBuilder().setNoPath(this.noPath).setLspa(this.lspa).setMetrics((List)Lists.newArrayList((Object[])new Metrics[]{this.metrics})).setIro(this.iro).build());
        replies3.add(rBuilder.build());
        builder.setReplies((List)replies3);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.5.bin"));
        ArrayList replies4 = Lists.newArrayList();
        rBuilder = new RepliesBuilder();
        rBuilder.setRp(this.rpTrue);
        ArrayList paths = Lists.newArrayList();
        PathsBuilder paBuilder = new PathsBuilder();
        paBuilder.setEro(this.ero);
        paBuilder.setLspa(this.lspa);
        paBuilder.setMetrics((List)Lists.newArrayList((Object[])new Metrics[]{this.metrics}));
        paBuilder.setIro(this.iro);
        paBuilder.setOf(this.of);
        paths.add(paBuilder.build());
        rBuilder.setResult((Result)new SuccessCaseBuilder().setSuccess(new SuccessBuilder().setPaths((List)paths).build()).build()).build();
        replies4.add(rBuilder.build());
        builder.setReplies((List)replies4);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(new PcrepMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Replies cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(new PcrepMessageBuilder().setReplies(Collections.emptyList()).build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Replies cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotificationMsg() throws IOException, PCEPDeserializerException {
        CNotification cn1 = new CNotificationBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setType(Short.valueOf((short)1)).setValue(Short.valueOf((short)1)).build();
        ArrayList innerNot = Lists.newArrayList();
        innerNot.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.NotificationsBuilder().setCNotification(cn1).build());
        ArrayList rps = Lists.newArrayList();
        rps.add(new RpsBuilder().setRp(this.rpFalse).build());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCNtf.5.bin"));
        PCEPNotificationMessageParser parser = new PCEPNotificationMessageParser(this.objectRegistry);
        PcntfMessageBuilder builder = new PcntfMessageBuilder();
        ArrayList nots = Lists.newArrayList();
        NotificationsBuilder b = new NotificationsBuilder();
        b.setNotifications((List)innerNot);
        b.setRps((List)rps);
        nots.add(b.build());
        ArrayList innerNot1 = Lists.newArrayList();
        innerNot1.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.NotificationsBuilder().setCNotification(cn1).build());
        innerNot1.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.NotificationsBuilder().setCNotification(cn1).build());
        ArrayList rps1 = Lists.newArrayList();
        rps1.add(new RpsBuilder().setRp(this.rpFalse).build());
        rps1.add(new RpsBuilder().setRp(this.rpFalse).build());
        b.setNotifications((List)innerNot1);
        b.setRps((List)rps1);
        nots.add(b.build());
        builder.setNotifications((List)nots);
        Assert.assertEquals((Object)new PcntfBuilder().setPcntfMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcntfBuilder().setPcntfMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testErrorMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCErr.5.bin"));
        ErrorObject error1 = new ErrorObjectBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setType(Short.valueOf((short)3)).setValue(Short.valueOf((short)1)).build();
        PCEPErrorMessageParser parser = new PCEPErrorMessageParser(this.ctx.getObjectHandlerRegistry());
        ArrayList<Errors> innerErr = new ArrayList<Errors>();
        PcerrMessageBuilder builder = new PcerrMessageBuilder();
        ArrayList rps = Lists.newArrayList();
        rps.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.RpsBuilder().setRp(this.rpFalse).build());
        innerErr.add(new ErrorsBuilder().setErrorObject(error1).build());
        builder.setErrors(innerErr);
        builder.setErrorType((ErrorType)new RequestCaseBuilder().setRequest(new RequestBuilder().setRps((List)rps).build()).build());
        Assert.assertEquals((Object)new PcerrBuilder().setPcerrMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCErr.3.bin"));
        error1 = new ErrorObjectBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setType(Short.valueOf((short)3)).setValue(Short.valueOf((short)1)).build();
        innerErr = new ArrayList();
        innerErr.add(new ErrorsBuilder().setErrorObject(error1).build());
        builder.setErrors(innerErr);
        builder.setErrorType((ErrorType)new SessionCaseBuilder().setSession(new SessionBuilder().setOpen(this.open).build()).build());
        Assert.assertEquals((Object)new PcerrBuilder().setPcerrMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(new PcerrMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Errors should not be empty.", (Object)e.getMessage());
        }
        try {
            parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(new PcerrMessageBuilder().setErrors(Collections.emptyList()).build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Errors should not be empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testReqMsgWithVendorInfoObjects() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCReq.7.bin"));
        PCEPRequestMessageParser parser = new PCEPRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        ArrayList reqs1 = Lists.newArrayList();
        RequestsBuilder rBuilder = new RequestsBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setVendorInformationObject(this.viObjects);
        SegmentComputationBuilder sBuilder = new SegmentComputationBuilder();
        sBuilder.setP2p(new P2pBuilder().setEndpointsObj(this.endpoints).setVendorInformationObject(this.viObjects).build());
        rBuilder.setSegmentComputation(sBuilder.build());
        reqs1.add(rBuilder.build());
        builder.setSvec((List)Lists.newArrayList((Object[])new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec[]{new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.SvecBuilder().setSvec(this.svec).setVendorInformationObject(this.viObjects).build()}));
        builder.setRequests((List)reqs1);
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testRepMsgWithVendorInforObjects() throws IOException, PCEPDeserializerException {
        PCEPReplyMessageParser parser = new PCEPReplyMessageParser(this.objectRegistry);
        PcrepMessageBuilder builder = new PcrepMessageBuilder();
        RepliesBuilder rBuilder = new RepliesBuilder();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.6.bin"));
        ArrayList replies = Lists.newArrayList();
        rBuilder = new RepliesBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setVendorInformationObject(this.viObjects);
        ArrayList paths = Lists.newArrayList();
        PathsBuilder paBuilder = new PathsBuilder();
        paBuilder.setEro(this.ero);
        paths.add(paBuilder.build());
        rBuilder.setResult((Result)new SuccessCaseBuilder().setSuccess(new SuccessBuilder().setPaths((List)paths).setVendorInformationObject(this.viObjects).build()).build()).build();
        replies.add(rBuilder.build());
        builder.setReplies((List)replies);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testMonRepMsg() throws PCEPDeserializerException, IOException {
        PCEPMonitoringReplyMessageParser parser = new PCEPMonitoringReplyMessageParser(this.objectRegistry);
        PcmonrepMessageBuilder builder = new PcmonrepMessageBuilder();
        builder.setMonitoring(this.monitoring);
        builder.setMonitoringMetricsList((MonitoringMetricsList)new GeneralMetricsListBuilder().setMetricPce((List)Lists.newArrayList((Object[])new MetricPce[]{new MetricPceBuilder().setPceId(this.pceId).build()})).build());
        byte[] msgBytes = new byte[]{32, 9, 0, 24, 19, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 100, 25, 16, 0, 8, 127, 0, 0, 2};
        ByteBuf result = Unpooled.wrappedBuffer((byte[])msgBytes);
        Assert.assertEquals((Object)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        builder.setMonitoring(this.monitoring);
        builder.setPccIdReq(this.pccIdReq);
        SpecificMetricsBuilder smBuilder = new SpecificMetricsBuilder();
        smBuilder.setRp(this.rpTrue);
        ArrayList metricPces = Lists.newArrayList();
        metricPces.add(new MetricPceBuilder().setOverload(this.overload).setPceId(this.pceId).setProcTime(this.procTime).build());
        metricPces.add(new MetricPceBuilder().setPceId(this.pceId).setProcTime(this.procTime).build());
        smBuilder.setMetricPce((List)metricPces);
        SpecificMetricsBuilder smBuilder2 = new SpecificMetricsBuilder();
        ArrayList metricPces2 = Lists.newArrayList();
        smBuilder2.setRp(this.rpTrue);
        metricPces2.add(new MetricPceBuilder().setOverload(this.overload).setPceId(this.pceId).build());
        smBuilder2.setMetricPce((List)metricPces2);
        builder.setMonitoringMetricsList((MonitoringMetricsList)new SpecificMetricsListBuilder().setSpecificMetrics((List)Lists.newArrayList((Object[])new SpecificMetrics[]{smBuilder.build(), smBuilder2.build()})).build());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCMonRep.bin"));
        Assert.assertEquals((Object)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testRepWithMonitoring() throws IOException, PCEPDeserializerException {
        PCEPReplyMessageParser parser = new PCEPReplyMessageParser(this.objectRegistry);
        PcrepMessageBuilder builder = new PcrepMessageBuilder();
        RepliesBuilder rBuilder = new RepliesBuilder();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRepMon.5.bin"));
        ArrayList replies4 = Lists.newArrayList();
        rBuilder = new RepliesBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setMonitoring(this.monitoring);
        rBuilder.setPccIdReq(this.pccIdReq);
        rBuilder.setMetricPce((List)Lists.newArrayList((Object[])new MetricPce[]{new MetricPceBuilder().setPceId(this.pceId).build()}));
        ArrayList paths = Lists.newArrayList();
        PathsBuilder paBuilder = new PathsBuilder();
        paBuilder.setEro(this.ero);
        paBuilder.setLspa(this.lspa);
        paBuilder.setMetrics((List)Lists.newArrayList((Object[])new Metrics[]{this.metrics}));
        paBuilder.setIro(this.iro);
        paBuilder.setOf(this.of);
        paths.add(paBuilder.build());
        rBuilder.setResult((Result)new SuccessCaseBuilder().setSuccess(new SuccessBuilder().setPaths((List)paths).build()).build()).build();
        replies4.add(rBuilder.build());
        builder.setReplies((List)replies4);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testReqWithMonitoring() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCReq.8.bin"));
        PCEPRequestMessageParser parser = new PCEPRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        ArrayList reqs1 = Lists.newArrayList();
        RequestsBuilder rBuilder = new RequestsBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setSegmentComputation(new SegmentComputationBuilder().setP2p(new P2pBuilder().setEndpointsObj(this.endpoints).build()).build());
        reqs1.add(rBuilder.build());
        MonitoringRequestBuilder monReqBuilder = new MonitoringRequestBuilder();
        monReqBuilder.setMonitoring(this.monitoring);
        monReqBuilder.setPccIdReq(this.pccIdReq);
        monReqBuilder.setPceIdList((List)Lists.newArrayList((Object[])new PceIdList[]{new PceIdListBuilder().setPceId(this.pceId).build()}));
        builder.setMonitoringRequest(monReqBuilder.build());
        builder.setRequests((List)reqs1);
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testMonReqMsg() throws PCEPDeserializerException, IOException {
        PCEPMonitoringRequestMessageParser parser = new PCEPMonitoringRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        MonitoringRequestBuilder monReqBuilder = new MonitoringRequestBuilder();
        monReqBuilder.setMonitoring(this.monitoring);
        monReqBuilder.setPceIdList((List)Lists.newArrayList((Object[])new PceIdList[]{new PceIdListBuilder().setPceId(this.pceId).build()}));
        builder.setMonitoringRequest(monReqBuilder.build());
        byte[] msgBytes = new byte[]{32, 8, 0, 24, 19, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 100, 25, 16, 0, 8, 127, 0, 0, 2};
        ByteBuf result = Unpooled.wrappedBuffer((byte[])msgBytes);
        Assert.assertEquals((Object)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCMonReq.bin"));
        ArrayList reqs2 = Lists.newArrayList();
        RequestsBuilder rBuilder1 = new RequestsBuilder();
        rBuilder1.setRp(this.rpTrue);
        P2pBuilder p2pBuilder = new P2pBuilder();
        p2pBuilder.setEndpointsObj(this.endpoints);
        p2pBuilder.setMetrics((List)Lists.newArrayList((Object[])new Metrics[]{this.metrics}));
        p2pBuilder.setIro(this.iro);
        rBuilder1.setSegmentComputation(new SegmentComputationBuilder().setP2p(p2pBuilder.build()).build());
        reqs2.add(rBuilder1.build());
        builder.setRequests((List)reqs2);
        builder.setSvec((List)Lists.newArrayList((Object[])new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec[]{new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.SvecBuilder().setSvec(this.svec).build()}));
        monReqBuilder.setMonitoring(this.monitoring);
        monReqBuilder.setPccIdReq(this.pccIdReq);
        PceIdList pceIdList = new PceIdListBuilder().setPceId(this.pceId).build();
        monReqBuilder.setPceIdList((List)Lists.newArrayList((Object[])new PceIdList[]{pceIdList, pceIdList}));
        builder.setMonitoringRequest(monReqBuilder.build());
        Assert.assertEquals((Object)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), Collections.emptyList()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }
}

