/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.parser.subobject.XROAsNumberSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.XROIpv4PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.XROIpv6PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.XROPathKey128SubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.XROPathKey32SubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.XROSRLGSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.XROUnnumberedInterfaceSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.SrlgId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.SrlgCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.srlg._case.SrlgBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;

public class PCEPXROSubobjectParserTest {
    private static final byte[] ip4PrefixBytes = new byte[]{1, 8, -1, -1, -1, -1, 22, 0};
    private static final byte[] ip6PrefixBytes = new byte[]{-126, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, 1};
    private static final byte[] srlgBytes = new byte[]{-94, 8, 18, 52, 86, 120, 0, 2};
    private static final byte[] unnumberedBytes = new byte[]{-124, 12, 0, 1, 18, 52, 80, 0, -1, -1, -1, -1};
    private static final byte[] asNumberBytes = new byte[]{-96, 4, 0, 100};
    private static final byte[] pathKey32Bytes = new byte[]{-64, 8, 18, 52, 18, 52, 80, 0};
    private static final byte[] pathKey128Bytes = new byte[]{-63, 20, 18, 52, 18, 52, 86, 120, -102, -68, -34, 18, 52, 84, 0, 0, 0, 0, 0, 0};

    @Test
    public void testXROIp4PrefixSubobject() throws PCEPDeserializerException {
        XROIpv4PrefixSubobjectParser parser = new XROIpv4PrefixSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        subs.setMandatory(Boolean.valueOf(false));
        subs.setAttribute(ExcludeRouteSubobjects.Attribute.Interface);
        subs.setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/22"))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])ip4PrefixBytes, (int)2)), false));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])ip4PrefixBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testXROIp6PrefixSubobject() throws PCEPDeserializerException {
        XROIpv6PrefixSubobjectParser parser = new XROIpv6PrefixSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        subs.setMandatory(Boolean.valueOf(true));
        subs.setAttribute(ExcludeRouteSubobjects.Attribute.Node);
        subs.setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(Ipv6Util.prefixForBytes((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)22))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])ip6PrefixBytes, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])ip6PrefixBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testXROSrlgSubobject() throws PCEPDeserializerException {
        XROSRLGSubobjectParser parser = new XROSRLGSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        subs.setMandatory(Boolean.valueOf(true));
        subs.setAttribute(ExcludeRouteSubobjects.Attribute.Srlg);
        subs.setSubobjectType((SubobjectType)new SrlgCaseBuilder().setSrlg(new SrlgBuilder().setSrlgId(new SrlgId(Long.valueOf(305419896L))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])srlgBytes, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])srlgBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testXROUnnumberedSubobject() throws PCEPDeserializerException {
        XROUnnumberedInterfaceSubobjectParser parser = new XROUnnumberedInterfaceSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        subs.setMandatory(Boolean.valueOf(true));
        subs.setAttribute(ExcludeRouteSubobjects.Attribute.Node);
        subs.setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(new UnnumberedBuilder().setRouterId(Long.valueOf(305418240L)).setInterfaceId(Long.valueOf(0xFFFFFFFFL)).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])unnumberedBytes, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])unnumberedBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testXROAsNumberSubobject() throws PCEPDeserializerException {
        XROAsNumberSubobjectParser parser = new XROAsNumberSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        subs.setMandatory(Boolean.valueOf(true));
        subs.setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Long.valueOf(100L))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])asNumberBytes, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])asNumberBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testXROPathKey32Subobject() throws PCEPDeserializerException {
        XROPathKey32SubobjectParser parser = new XROPathKey32SubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        subs.setMandatory(Boolean.valueOf(true));
        PathKeyBuilder pBuilder = new PathKeyBuilder();
        pBuilder.setPceId(new PceId(new byte[]{18, 52, 80, 0}));
        pBuilder.setPathKey(new PathKey(Integer.valueOf(4660)));
        subs.setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])pathKey32Bytes, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])pathKey32Bytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testXROPathKey128Subobject() throws PCEPDeserializerException {
        XROPathKey128SubobjectParser parser = new XROPathKey128SubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        subs.setMandatory(Boolean.valueOf(true));
        PathKeyBuilder pBuilder = new PathKeyBuilder();
        pBuilder.setPceId(new PceId(new byte[]{18, 52, 86, 120, -102, -68, -34, 18, 52, 84, 0, 0, 0, 0, 0, 0}));
        pBuilder.setPathKey(new PathKey(Integer.valueOf(4660)));
        subs.setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])pathKey128Bytes, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        XROPathKey128SubobjectParser.serializeSubobject((Subobject)subs.build(), (ByteBuf)buff);
        Assert.assertArrayEquals((byte[])pathKey128Bytes, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }
}

