/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.PCEPTerminationReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSessionListener
implements PCEPSessionListener {
    public final List<Message> messages = Lists.newArrayList();
    public boolean up = false;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSessionListener.class);

    public void onMessage(PCEPSession session, Message message) {
        LOG.debug("Received message: {} {}", message.getClass(), (Object)message);
        this.messages.add(message);
    }

    public synchronized void onSessionUp(PCEPSession session) {
        LOG.debug("Session up.");
        this.up = true;
        this.notifyAll();
    }

    public void onSessionDown(PCEPSession session, Exception exception) {
        LOG.debug("Session down.", (Throwable)exception);
        this.up = false;
    }

    public void onSessionTerminated(PCEPSession session, PCEPTerminationReason cause) {
        LOG.debug("Session terminated. Cause : {}", (Object)cause.toString());
        this.up = false;
    }
}

