/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.SessionCase;

public class UtilTest {
    private static final Open OPEN = new OpenBuilder().build();

    @Test
    public void testCreateErrorMessageWithOpen() {
        Message msg = Util.createErrorMessage((PCEPErrors)PCEPErrors.BAD_LABEL_VALUE, (Open)OPEN);
        Assert.assertTrue((boolean)(msg instanceof Pcerr));
        Pcerr errMsg = (Pcerr)msg;
        Assert.assertTrue((boolean)(errMsg.getPcerrMessage().getErrorType() instanceof SessionCase));
        SessionCase sessionCase = (SessionCase)errMsg.getPcerrMessage().getErrorType();
        Assert.assertEquals((Object)OPEN, (Object)sessionCase.getSession().getOpen());
        ErrorObject errorObject = ((Errors)errMsg.getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((long)PCEPErrors.BAD_LABEL_VALUE.getErrorType(), (long)errorObject.getType().shortValue());
        Assert.assertEquals((long)PCEPErrors.BAD_LABEL_VALUE.getErrorValue(), (long)errorObject.getValue().shortValue());
    }

    @Test
    public void testCreateErrorMessage() {
        Message msg = Util.createErrorMessage((PCEPErrors)PCEPErrors.BAD_LABEL_VALUE, null);
        Assert.assertTrue((boolean)(msg instanceof Pcerr));
        Pcerr errMsg = (Pcerr)msg;
        Assert.assertNull((Object)errMsg.getPcerrMessage().getErrorType());
        ErrorObject errorObject = ((Errors)errMsg.getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((long)PCEPErrors.BAD_LABEL_VALUE.getErrorType(), (long)errorObject.getType().shortValue());
        Assert.assertEquals((long)PCEPErrors.BAD_LABEL_VALUE.getErrorValue(), (long)errorObject.getValue().shortValue());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPrivateConstructor() throws Throwable {
        Constructor c = Util.class.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        try {
            c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

