/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.protocol.pcep.SessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionNegotiator
extends ChannelInboundHandlerAdapter
implements SessionNegotiator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSessionNegotiator.class);
    protected final Channel channel;
    protected final Promise<PCEPSessionImpl> promise;

    protected AbstractSessionNegotiator(Promise<PCEPSessionImpl> promise, Channel channel) {
        this.promise = Objects.requireNonNull(promise);
        this.channel = Objects.requireNonNull(channel);
    }

    protected final void negotiationSuccessful(PCEPSessionImpl session) {
        LOG.debug("Negotiation on channel {} successful with session {}", (Object)this.channel, (Object)session);
        this.channel.pipeline().replace((ChannelHandler)this, "session", (ChannelHandler)session);
        this.promise.setSuccess((Object)session);
    }

    protected void negotiationFailed(Throwable cause) {
        LOG.debug("Negotiation on channel {} failed", (Object)this.channel, (Object)cause);
        this.channel.close();
        this.promise.setFailure(cause);
    }

    protected final void sendMessage(Message msg) {
        this.channel.writeAndFlush((Object)msg).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                LOG.info("Failed to send message {}", (Object)msg, (Object)f.cause());
                this.negotiationFailed(f.cause());
            } else {
                LOG.trace("Message {} sent to socket", (Object)msg);
            }
        }));
    }

    public final void channelActive(ChannelHandlerContext ctx) {
        LOG.debug("Starting session negotiation on channel {}", (Object)this.channel);
        try {
            this.startNegotiation();
        }
        catch (Exception e) {
            LOG.warn("Unexpected negotiation failure", (Throwable)e);
            this.negotiationFailed(e);
        }
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        LOG.debug("Negotiation read invoked on channel {}", (Object)this.channel);
        try {
            this.handleMessage((Message)msg);
        }
        catch (Exception e) {
            LOG.debug("Unexpected error while handling negotiation message {}", msg, (Object)e);
            this.negotiationFailed(e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.info("Unexpected error during negotiation", cause);
        this.negotiationFailed(cause);
    }

    protected abstract void startNegotiation() throws ExecutionException;

    protected abstract void handleMessage(Message var1);
}

