/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCEPProtocolSessionPromise<S extends PCEPSession>
extends DefaultPromise<S> {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPProtocolSessionPromise.class);
    private InetSocketAddress address;
    private final int retryTimer;
    private final int connectTimeout;
    private final Bootstrap b;
    private @GuardedBy(value={"this"}) Future<?> pending;

    PCEPProtocolSessionPromise(EventExecutor executor, InetSocketAddress address, int retryTimer, int connectTimeout, Bootstrap b) {
        super(executor);
        this.address = Objects.requireNonNull(address);
        this.retryTimer = retryTimer;
        this.connectTimeout = connectTimeout;
        this.b = Objects.requireNonNull(b);
    }

    synchronized void connect() {
        PCEPProtocolSessionPromise lock = this;
        try {
            LOG.debug("Promise {} attempting connect for {}ms", (Object)lock, (Object)this.connectTimeout);
            if (this.address.isUnresolved()) {
                this.address = new InetSocketAddress(this.address.getHostName(), this.address.getPort());
            }
            this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
            this.b.remoteAddress((SocketAddress)this.address);
            ChannelFuture connectFuture = this.b.connect();
            connectFuture.addListener((GenericFutureListener)new BootstrapConnectListener());
            this.pending = connectFuture;
        }
        catch (Exception e) {
            LOG.info("Failed to connect to {}", (Object)this.address, (Object)e);
            this.setFailure(e);
        }
    }

    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.pending.cancel(mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    public synchronized Promise<S> setSuccess(S result) {
        LOG.debug("Promise {} completed", (Object)this);
        return super.setSuccess(result);
    }

    private class BootstrapConnectListener
    implements ChannelFutureListener {
        private BootstrapConnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture cf) {
            PCEPProtocolSessionPromise pCEPProtocolSessionPromise = PCEPProtocolSessionPromise.this;
            synchronized (pCEPProtocolSessionPromise) {
                LOG.debug("Promise {} connection resolved", (Object)PCEPProtocolSessionPromise.this);
                Preconditions.checkState((boolean)PCEPProtocolSessionPromise.this.pending.equals(cf));
                if (PCEPProtocolSessionPromise.this.isCancelled()) {
                    if (cf.isSuccess()) {
                        LOG.debug("Closing channel for cancelled promise {}", (Object)PCEPProtocolSessionPromise.this);
                        cf.channel().close();
                    }
                } else if (cf.isSuccess()) {
                    LOG.debug("Promise {} connection successful", (Object)PCEPProtocolSessionPromise.this);
                } else {
                    LOG.debug("Attempt to connect to {} failed", (Object)PCEPProtocolSessionPromise.this.address, (Object)cf.cause());
                    if (PCEPProtocolSessionPromise.this.retryTimer == 0) {
                        LOG.debug("Retry timer value is 0. Reconnection will not be attempted");
                        PCEPProtocolSessionPromise.this.setFailure(cf.cause());
                        return;
                    }
                    EventLoop loop = cf.channel().eventLoop();
                    loop.schedule(() -> {
                        PCEPProtocolSessionPromise pCEPProtocolSessionPromise = PCEPProtocolSessionPromise.this;
                        synchronized (pCEPProtocolSessionPromise) {
                            LOG.debug("Attempting to connect to {}", (Object)PCEPProtocolSessionPromise.this.address);
                            ChannelFuture reconnectFuture = PCEPProtocolSessionPromise.this.b.connect();
                            reconnectFuture.addListener((GenericFutureListener)this);
                            PCEPProtocolSessionPromise.this.pending = (Future)reconnectFuture;
                        }
                    }, (long)PCEPProtocolSessionPromise.this.retryTimer, TimeUnit.SECONDS);
                    LOG.debug("Next reconnection attempt in {}s", (Object)PCEPProtocolSessionPromise.this.retryTimer);
                }
            }
        }
    }
}

