/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Ticker;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.protocol.pcep.PCEPCloseTermination;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.PCEPTerminationReason;
import org.opendaylight.protocol.pcep.TerminationReason;
import org.opendaylight.protocol.pcep.impl.PCEPSessionState;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.CloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.CloseMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.KeepaliveMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcerrMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.message.CCloseMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.CCloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.keepalive.message.KeepaliveMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class PCEPSessionImpl
extends SimpleChannelInboundHandler<Message>
implements PCEPSession {
    private static final long MINUTE = TimeUnit.MINUTES.toNanos(1L);
    private static Ticker TICKER = Ticker.systemTicker();
    private volatile long lastMessageSentAt;
    private long lastMessageReceivedAt;
    private final Queue<Long> unknownMessagesTimes = new LinkedList<Long>();
    private final PCEPSessionListener listener;
    private final Open localOpen;
    private final Open remoteOpen;
    private static final Logger LOG = LoggerFactory.getLogger(PCEPSessionImpl.class);
    private int maxUnknownMessages;
    private final @GuardedBy(value={"this"}) AtomicBoolean closed = new AtomicBoolean(false);
    private final Channel channel;
    private final Keepalive kaMessage = new KeepaliveBuilder().setKeepaliveMessage(new KeepaliveMessageBuilder().build()).build();
    private final PCEPSessionState sessionState;

    PCEPSessionImpl(PCEPSessionListener listener, int maxUnknownMessages, Channel channel, Open localOpen, Open remoteOpen) {
        this.listener = Objects.requireNonNull(listener);
        this.channel = Objects.requireNonNull(channel);
        this.localOpen = Objects.requireNonNull(localOpen);
        this.remoteOpen = Objects.requireNonNull(remoteOpen);
        this.lastMessageReceivedAt = TICKER.read();
        if (maxUnknownMessages != 0) {
            this.maxUnknownMessages = maxUnknownMessages;
        }
        if (this.getDeadTimerValue() != 0) {
            channel.eventLoop().schedule(this::handleDeadTimer, (long)this.getDeadTimerValue().intValue(), TimeUnit.SECONDS);
        }
        if (this.getKeepAliveTimerValue() != 0) {
            channel.eventLoop().schedule(this::handleKeepaliveTimer, (long)this.getKeepAliveTimerValue().intValue(), TimeUnit.SECONDS);
        }
        LOG.info("Session {}[{}] <-> {}[{}] started", new Object[]{channel.localAddress(), localOpen.getSessionId(), channel.remoteAddress(), remoteOpen.getSessionId()});
        this.sessionState = new PCEPSessionState(remoteOpen, localOpen, channel);
    }

    public final Integer getKeepAliveTimerValue() {
        return this.localOpen.getKeepalive().intValue();
    }

    public final Integer getDeadTimerValue() {
        return this.remoteOpen.getDeadTimer().intValue();
    }

    private synchronized void handleDeadTimer() {
        long ct = TICKER.read();
        long nextDead = this.lastMessageReceivedAt + TimeUnit.SECONDS.toNanos(this.getDeadTimerValue().intValue());
        if (this.channel.isActive()) {
            if (ct >= nextDead) {
                LOG.debug("DeadTimer expired. {}", (Object)new Date());
                this.terminate(TerminationReason.EXP_DEADTIMER);
            } else {
                this.channel.eventLoop().schedule(this::handleDeadTimer, nextDead - ct, TimeUnit.NANOSECONDS);
            }
        }
    }

    private void handleKeepaliveTimer() {
        long ct = TICKER.read();
        long nextKeepalive = this.lastMessageSentAt + TimeUnit.SECONDS.toNanos(this.getKeepAliveTimerValue().intValue());
        if (this.channel.isActive()) {
            if (ct >= nextKeepalive) {
                this.sendMessage((Message)this.kaMessage);
                nextKeepalive = this.lastMessageSentAt + TimeUnit.SECONDS.toNanos(this.getKeepAliveTimerValue().intValue());
            }
            this.channel.eventLoop().schedule(this::handleKeepaliveTimer, nextKeepalive - ct, TimeUnit.NANOSECONDS);
        }
    }

    @VisibleForTesting
    void handleException(Throwable cause) {
        LOG.error("Exception captured for session {}, closing session.", (Object)this, (Object)cause);
        this.terminate(TerminationReason.UNKNOWN);
    }

    public Future<Void> sendMessage(Message msg) {
        ChannelFuture f = this.channel.writeAndFlush((Object)msg);
        this.lastMessageSentAt = TICKER.read();
        this.sessionState.updateLastSentMsg();
        if (!(msg instanceof KeepaliveMessage)) {
            LOG.debug("PCEP Message enqueued: {}", (Object)msg);
        }
        if (msg instanceof PcerrMessage) {
            this.sessionState.setLastSentError(msg);
        }
        f.addListener((GenericFutureListener)((ChannelFutureListener)arg -> {
            if (arg.isSuccess()) {
                LOG.trace("Message sent to socket: {}", (Object)msg);
            } else {
                LOG.debug("Message not sent: {}", (Object)msg, (Object)arg.cause());
            }
        }));
        return f;
    }

    @VisibleForTesting
    ChannelFuture closeChannel() {
        LOG.info("Closing PCEP session channel: {}", (Object)this.channel);
        return this.channel.close();
    }

    @VisibleForTesting
    public synchronized boolean isClosed() {
        return this.closed.get();
    }

    public synchronized void close() {
        this.close(null);
    }

    public void close(TerminationReason reason) {
        if (this.closed.getAndSet(true)) {
            LOG.debug("Session is already closed.");
            return;
        }
        if (reason != null) {
            LOG.info("Closing PCEP session with reason {}: {}", (Object)reason, (Object)this);
            this.sendMessage((Message)new CloseBuilder().setCCloseMessage(new CCloseMessageBuilder().setCClose(new CCloseBuilder().setReason(Short.valueOf(reason.getShortValue())).build()).build()).build());
        } else {
            LOG.info("Closing PCEP session: {}", (Object)this);
        }
        this.closeChannel();
    }

    public Tlvs getRemoteTlvs() {
        return this.remoteOpen.getTlvs();
    }

    public InetAddress getRemoteAddress() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getAddress();
    }

    private synchronized void terminate(TerminationReason reason) {
        if (this.closed.get()) {
            LOG.debug("Session {} is already closed.", (Object)this);
            return;
        }
        this.close(reason);
        this.listener.onSessionTerminated((PCEPSession)this, (PCEPTerminationReason)new PCEPCloseTermination(reason));
    }

    synchronized void endOfInput() {
        if (!this.closed.getAndSet(true)) {
            this.listener.onSessionDown((PCEPSession)this, (Exception)new IOException("End of input detected. Close the session."));
        }
    }

    private void sendErrorMessage(PCEPErrors value) {
        this.sendErrorMessage(value, null);
    }

    private void sendErrorMessage(PCEPErrors value, Open open) {
        this.sendMessage(Util.createErrorMessage(value, open));
    }

    @VisibleForTesting
    void handleMalformedMessage(PCEPErrors error) {
        long ct = TICKER.read();
        this.sendErrorMessage(error);
        if (error == PCEPErrors.CAPABILITY_NOT_SUPPORTED) {
            this.unknownMessagesTimes.add(ct);
            while (ct - this.unknownMessagesTimes.peek() > MINUTE) {
                this.unknownMessagesTimes.remove();
            }
            if (this.unknownMessagesTimes.size() > this.maxUnknownMessages) {
                this.terminate(TerminationReason.TOO_MANY_UNKNOWN_MSGS);
            }
        }
    }

    public synchronized void handleMessage(Message msg) {
        if (this.closed.get()) {
            LOG.debug("PCEP Session {} is already closed, skip handling incoming message {}", (Object)this, (Object)msg);
            return;
        }
        this.lastMessageReceivedAt = TICKER.read();
        this.sessionState.updateLastReceivedMsg();
        if (!(msg instanceof KeepaliveMessage)) {
            LOG.debug("PCEP message {} received.", (Object)msg);
        }
        if (!(msg instanceof KeepaliveMessage)) {
            if (msg instanceof OpenMessage) {
                this.sendErrorMessage(PCEPErrors.ATTEMPT_2ND_SESSION);
            } else if (msg instanceof CloseMessage) {
                this.close();
                this.listener.onSessionTerminated((PCEPSession)this, (PCEPTerminationReason)new PCEPCloseTermination(TerminationReason.forValue((short)((CloseMessage)msg).getCCloseMessage().getCClose().getReason())));
            } else {
                if (msg instanceof PcerrMessage) {
                    this.sessionState.setLastReceivedError(msg);
                }
                this.listener.onMessage((PCEPSession)this, msg);
            }
        }
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)((Object)this))).toString();
    }

    private MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("channel", (Object)this.channel);
        toStringHelper.add("localOpen", (Object)this.localOpen);
        toStringHelper.add("remoteOpen", (Object)this.remoteOpen);
        return toStringHelper;
    }

    @VisibleForTesting
    void sessionUp() {
        try {
            this.listener.onSessionUp((PCEPSession)this);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @VisibleForTesting
    final Queue<Long> getUnknownMessagesTimes() {
        return this.unknownMessagesTimes;
    }

    public Messages getMessages() {
        return this.sessionState.getMessages(this.unknownMessagesTimes.size());
    }

    public LocalPref getLocalPref() {
        return this.sessionState.getLocalPref();
    }

    public PeerPref getPeerPref() {
        return this.sessionState.getPeerPref();
    }

    public Open getLocalOpen() {
        return this.sessionState.getLocalOpen();
    }

    public final synchronized void channelInactive(ChannelHandlerContext ctx) {
        LOG.debug("Channel {} inactive.", (Object)ctx.channel());
        this.endOfInput();
        try {
            super.channelInactive(ctx);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to delegate channel inactive event on channel " + ctx.channel(), e);
        }
    }

    protected final synchronized void channelRead0(ChannelHandlerContext ctx, Message msg) {
        LOG.debug("Message was received: {}", (Object)msg);
        this.handleMessage(msg);
    }

    public final synchronized void handlerAdded(ChannelHandlerContext ctx) {
        this.sessionUp();
    }

    public synchronized void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.handleException(cause);
    }

    public Tlvs getLocalTlvs() {
        return this.localOpen.getTlvs();
    }

    @VisibleForTesting
    static void setTicker(Ticker ticker) {
        TICKER = ticker;
    }
}

