package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container tls {
 *   presence true;
 *   leaf keystore {
 *     type string;
 *   }
 *   leaf keystore-type {
 *     type store-type;
 *   }
 *   leaf keystore-path-type {
 *     type path-type;
 *   }
 *   leaf keystore-password {
 *     type string;
 *   }
 *   leaf certificate-password {
 *     type string;
 *   }
 *   leaf truststore {
 *     type string;
 *   }
 *   leaf truststore-type {
 *     type store-type;
 *   }
 *   leaf truststore-path-type {
 *     type path-type;
 *   }
 *   leaf truststore-password {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-app-config/pcep-dispatcher-config/tls</i>
 *
 * <p>To create instances of this class use {@link TlsBuilder}.
 * @see TlsBuilder
 *
 */
public interface Tls
    extends
    ChildOf<PcepDispatcherConfig>,
    Augmentable<Tls>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tls");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls.class;
    }
    
    /**
     * keystore location
     *
     *
     *
     * @return <code>java.lang.String</code> <code>keystore</code>, or <code>null</code> if not present
     */
    @Nullable String getKeystore();
    
    /**
     * keystore type (JKS or PKCS12)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType</code> <code>keystoreType</code>, or <code>null</code> if not present
     */
    @Nullable StoreType getKeystoreType();
    
    /**
     * keystore path type (CLASSPATH or PATH)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType</code> <code>keystorePathType</code>, or <code>null</code> if not present
     */
    @Nullable PathType getKeystorePathType();
    
    /**
     * password protecting keystore
     *
     *
     *
     * @return <code>java.lang.String</code> <code>keystorePassword</code>, or <code>null</code> if not present
     */
    @Nullable String getKeystorePassword();
    
    /**
     * password protecting certificate
     *
     *
     *
     * @return <code>java.lang.String</code> <code>certificatePassword</code>, or <code>null</code> if not present
     */
    @Nullable String getCertificatePassword();
    
    /**
     * truststore location
     *
     *
     *
     * @return <code>java.lang.String</code> <code>truststore</code>, or <code>null</code> if not present
     */
    @Nullable String getTruststore();
    
    /**
     * truststore type (JKS or PKCS12)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType</code> <code>truststoreType</code>, or <code>null</code> if not present
     */
    @Nullable StoreType getTruststoreType();
    
    /**
     * truststore path type (CLASSPATH or PATH)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType</code> <code>truststorePathType</code>, or <code>null</code> if not present
     */
    @Nullable PathType getTruststorePathType();
    
    /**
     * password protecting truststore
     *
     *
     *
     * @return <code>java.lang.String</code> <code>truststorePassword</code>, or <code>null</code> if not present
     */
    @Nullable String getTruststorePassword();

}

