package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container pcep-dispatcher-config {
 *   leaf max-unknown-messages {
 *     type uint16 {
 *       range 1..max;
 *     }
 *     default 5;
 *   }
 *   container tls {
 *     presence true;
 *     leaf keystore {
 *       type string;
 *     }
 *     leaf keystore-type {
 *       type store-type;
 *     }
 *     leaf keystore-path-type {
 *       type path-type;
 *     }
 *     leaf keystore-password {
 *       type string;
 *     }
 *     leaf certificate-password {
 *       type string;
 *     }
 *     leaf truststore {
 *       type string;
 *     }
 *     leaf truststore-type {
 *       type store-type;
 *     }
 *     leaf truststore-path-type {
 *       type path-type;
 *     }
 *     leaf truststore-password {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-app-config/pcep-dispatcher-config</i>
 *
 * <p>To create instances of this class use {@link PcepDispatcherConfigBuilder}.
 * @see PcepDispatcherConfigBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PcepDispatcherConfig
    extends
    ChildOf<PcepAppConfigData>,
    Augmentable<PcepDispatcherConfig>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcep-dispatcher-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.@NonNull PcepDispatcherConfig obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMaxUnknownMessages());
        result = prime * result + Objects.hashCode(obj.getTls());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.@NonNull PcepDispatcherConfig thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxUnknownMessages(), other.getMaxUnknownMessages())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTls(), other.getTls())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.@NonNull PcepDispatcherConfig obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepDispatcherConfig");
        CodeHelpers.appendValue(helper, "maxUnknownMessages", obj.getMaxUnknownMessages());
        CodeHelpers.appendValue(helper, "tls", obj.getTls());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return maxUnknownMessages, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint16} maxUnknownMessages, or {@code null} if it is not present.
     *
     */
    Uint16 getMaxUnknownMessages();
    
    /**
     * Return tls, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls} tls, or {@code null} if it is not present.
     *
     */
    Tls getTls();

}

