package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link PcepDispatcherConfigBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepDispatcherConfigBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PcepDispatcherConfigBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepDispatcherConfigBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepDispatcherConfigBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PcepDispatcherConfigBuilder implements Builder<PcepDispatcherConfig> {

    private Uint16 _maxUnknownMessages;
    private Tls _tls;


    Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> augmentation = Collections.emptyMap();

    public PcepDispatcherConfigBuilder() {
    }
    
    

    public PcepDispatcherConfigBuilder(PcepDispatcherConfig base) {
        Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._maxUnknownMessages = base.getMaxUnknownMessages();
        this._tls = base.getTls();
    }


    public Uint16 getMaxUnknownMessages() {
        return _maxUnknownMessages;
    }
    
    public Tls getTls() {
        return _tls;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcepDispatcherConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    private static void checkMaxUnknownMessagesRange(final int value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..65535]]", value);
    }
    
    public PcepDispatcherConfigBuilder setMaxUnknownMessages(final Uint16 value) {
        if (value != null) {
            checkMaxUnknownMessagesRange(value.intValue());
            
        }
        this._maxUnknownMessages = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setMaxUnknownMessages(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public PcepDispatcherConfigBuilder setMaxUnknownMessages(final Integer value) {
        return setMaxUnknownMessages(CodeHelpers.compatUint(value));
    }
    
    public PcepDispatcherConfigBuilder setTls(final Tls value) {
        this._tls = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcepDispatcherConfigBuilder addAugmentation(Augmentation<PcepDispatcherConfig> augmentation) {
        Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcepDispatcherConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepDispatcherConfig build() {
        return new PcepDispatcherConfigImpl(this);
    }

    private static final class PcepDispatcherConfigImpl
        extends AbstractAugmentable<PcepDispatcherConfig>
        implements PcepDispatcherConfig {
    
        private final Uint16 _maxUnknownMessages;
        private final Tls _tls;
    
        PcepDispatcherConfigImpl(PcepDispatcherConfigBuilder base) {
            super(base.augmentation);
            this._maxUnknownMessages = base.getMaxUnknownMessages();
            this._tls = base.getTls();
        }
    
        @Override
        public Uint16 getMaxUnknownMessages() {
            return _maxUnknownMessages;
        }
        
        @Override
        public Tls getTls() {
            return _tls;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepDispatcherConfig.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepDispatcherConfig.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepDispatcherConfig.bindingToString(this);
        }
    }
}
