package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum StoreType implements Enumeration {
    JKS(0, "JKS"),
    
    PKCS12(1, "PKCS12")
    ;

    private static final Map<String, StoreType> NAME_MAP;
    private static final Map<Integer, StoreType> VALUE_MAP;

    static {
        final Builder<String, StoreType> nb = ImmutableMap.builder();
        final Builder<Integer, StoreType> vb = ImmutableMap.builder();
        for (StoreType enumItem : StoreType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private StoreType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding StoreType item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<StoreType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding StoreType item, or null if no such item exists
     */
    public static StoreType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
