package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link TlsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TlsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TlsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TlsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TlsBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class TlsBuilder implements Builder<Tls> {

    private String _certificatePassword;
    private String _keystore;
    private String _keystorePassword;
    private PathType _keystorePathType;
    private StoreType _keystoreType;
    private String _truststore;
    private String _truststorePassword;
    private PathType _truststorePathType;
    private StoreType _truststoreType;


    Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Collections.emptyMap();

    public TlsBuilder() {
    }
    
    

    public TlsBuilder(Tls base) {
        Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._certificatePassword = base.getCertificatePassword();
        this._keystore = base.getKeystore();
        this._keystorePassword = base.getKeystorePassword();
        this._keystorePathType = base.getKeystorePathType();
        this._keystoreType = base.getKeystoreType();
        this._truststore = base.getTruststore();
        this._truststorePassword = base.getTruststorePassword();
        this._truststorePathType = base.getTruststorePathType();
        this._truststoreType = base.getTruststoreType();
    }


    public String getCertificatePassword() {
        return _certificatePassword;
    }
    
    public String getKeystore() {
        return _keystore;
    }
    
    public String getKeystorePassword() {
        return _keystorePassword;
    }
    
    public PathType getKeystorePathType() {
        return _keystorePathType;
    }
    
    public StoreType getKeystoreType() {
        return _keystoreType;
    }
    
    public String getTruststore() {
        return _truststore;
    }
    
    public String getTruststorePassword() {
        return _truststorePassword;
    }
    
    public PathType getTruststorePathType() {
        return _truststorePathType;
    }
    
    public StoreType getTruststoreType() {
        return _truststoreType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Tls>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public TlsBuilder setCertificatePassword(final String value) {
        this._certificatePassword = value;
        return this;
    }
    
    public TlsBuilder setKeystore(final String value) {
        this._keystore = value;
        return this;
    }
    
    public TlsBuilder setKeystorePassword(final String value) {
        this._keystorePassword = value;
        return this;
    }
    
    public TlsBuilder setKeystorePathType(final PathType value) {
        this._keystorePathType = value;
        return this;
    }
    
    public TlsBuilder setKeystoreType(final StoreType value) {
        this._keystoreType = value;
        return this;
    }
    
    public TlsBuilder setTruststore(final String value) {
        this._truststore = value;
        return this;
    }
    
    public TlsBuilder setTruststorePassword(final String value) {
        this._truststorePassword = value;
        return this;
    }
    
    public TlsBuilder setTruststorePathType(final PathType value) {
        this._truststorePathType = value;
        return this;
    }
    
    public TlsBuilder setTruststoreType(final StoreType value) {
        this._truststoreType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TlsBuilder addAugmentation(Augmentation<Tls> augmentation) {
        Class<? extends Augmentation<Tls>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TlsBuilder removeAugmentation(Class<? extends Augmentation<Tls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tls build() {
        return new TlsImpl(this);
    }

    private static final class TlsImpl
        extends AbstractAugmentable<Tls>
        implements Tls {
    
        private final String _certificatePassword;
        private final String _keystore;
        private final String _keystorePassword;
        private final PathType _keystorePathType;
        private final StoreType _keystoreType;
        private final String _truststore;
        private final String _truststorePassword;
        private final PathType _truststorePathType;
        private final StoreType _truststoreType;
    
        TlsImpl(TlsBuilder base) {
            super(base.augmentation);
            this._certificatePassword = base.getCertificatePassword();
            this._keystore = base.getKeystore();
            this._keystorePassword = base.getKeystorePassword();
            this._keystorePathType = base.getKeystorePathType();
            this._keystoreType = base.getKeystoreType();
            this._truststore = base.getTruststore();
            this._truststorePassword = base.getTruststorePassword();
            this._truststorePathType = base.getTruststorePathType();
            this._truststoreType = base.getTruststoreType();
        }
    
        @Override
        public String getCertificatePassword() {
            return _certificatePassword;
        }
        
        @Override
        public String getKeystore() {
            return _keystore;
        }
        
        @Override
        public String getKeystorePassword() {
            return _keystorePassword;
        }
        
        @Override
        public PathType getKeystorePathType() {
            return _keystorePathType;
        }
        
        @Override
        public StoreType getKeystoreType() {
            return _keystoreType;
        }
        
        @Override
        public String getTruststore() {
            return _truststore;
        }
        
        @Override
        public String getTruststorePassword() {
            return _truststorePassword;
        }
        
        @Override
        public PathType getTruststorePathType() {
            return _truststorePathType;
        }
        
        @Override
        public StoreType getTruststoreType() {
            return _truststoreType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Tls.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Tls.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Tls.bindingToString(this);
        }
    }
}
