/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.pcep.spi.MessageRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCEPByteToMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPByteToMessageDecoder.class);
    private final MessageRegistry registry;

    public PCEPByteToMessageDecoder(MessageRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (!in.isReadable()) {
            LOG.debug("No more content in incoming buffer.");
            return;
        }
        in.markReaderIndex();
        LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
        ArrayList<Message> errors = new ArrayList<Message>();
        try {
            out.add(this.parse(in, errors));
        }
        catch (PCEPDeserializerException e) {
            LOG.warn("Failed to decode protocol message", (Throwable)e);
        }
        in.discardReadBytes();
        if (!errors.isEmpty()) {
            for (Object e : errors) {
                ctx.channel().writeAndFlush(e).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                    if (!f.isSuccess()) {
                        LOG.warn("Failed to send message {} to socket {}", new Object[]{e, ctx.channel(), f.cause()});
                    } else {
                        LOG.trace("Message {} sent to socket {}", e, (Object)ctx.channel());
                    }
                }));
            }
        }
    }

    private Message parse(ByteBuf buffer, List<Message> errors) throws PCEPDeserializerException {
        buffer.skipBytes(1);
        short type = buffer.readUnsignedByte();
        int msgLength = buffer.readUnsignedShort();
        int actualLength = buffer.readableBytes();
        ByteBuf msgBody = buffer.slice();
        if (actualLength != msgLength - 4) {
            throw new PCEPDeserializerException("Body size " + actualLength + " does not match header size " + (msgLength - 4));
        }
        buffer.skipBytes(actualLength);
        return this.registry.parseMessage((int)type, msgBody, errors);
    }
}

