/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.primitives.UnsignedBytes;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactoryDependencies;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.AbstractSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPPeerRegistry;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPSessionNegotiator
extends AbstractSessionNegotiator {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPSessionNegotiator.class);
    private static final Comparator<byte[]> COMPARATOR = UnsignedBytes.lexicographicalComparator();
    private final AbstractPCEPSessionNegotiatorFactory negFactory;
    private final PCEPSessionNegotiatorFactoryDependencies nfd;

    public PCEPSessionNegotiator(Channel channel, Promise<PCEPSessionImpl> promise, PCEPSessionNegotiatorFactoryDependencies dependencies, AbstractPCEPSessionNegotiatorFactory negFactory) {
        super(promise, channel);
        this.nfd = dependencies;
        this.negFactory = negFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startNegotiation() throws ExecutionException {
        PCEPSessionNegotiator lock = this;
        LOG.debug("Bootstrap negotiation for channel {} started", (Object)this.channel);
        final byte[] clientAddress = ((InetSocketAddress)this.channel.remoteAddress()).getAddress().getAddress();
        final PCEPPeerRegistry sessionReg = this.negFactory.getSessionRegistry();
        PCEPSessionNegotiator pCEPSessionNegotiator = lock;
        synchronized (pCEPSessionNegotiator) {
            if (sessionReg.getSessionReference(clientAddress).isPresent()) {
                byte[] serverAddress = ((InetSocketAddress)this.channel.localAddress()).getAddress().getAddress();
                if (COMPARATOR.compare(serverAddress, clientAddress) > 0) {
                    Optional<PCEPPeerRegistry.SessionReference> sessionRefMaybe = sessionReg.removeSessionReference(clientAddress);
                    try {
                        if (sessionRefMaybe.isPresent()) {
                            sessionRefMaybe.get().close();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected failure to close old session", (Throwable)e);
                    }
                } else {
                    this.negotiationFailed(new IllegalStateException("A conflicting session for address " + ((InetSocketAddress)this.channel.remoteAddress()).getAddress() + " found."));
                    return;
                }
            }
            final Short sessionId = sessionReg.nextSession(clientAddress);
            AbstractPCEPSessionNegotiator n = this.negFactory.createNegotiator(this.nfd, (Promise<PCEPSessionImpl>)this.promise, this.channel, sessionId);
            sessionReg.putSessionReference(clientAddress, new PCEPPeerRegistry.SessionReference(){

                @Override
                public void close() throws ExecutionException {
                    try {
                        sessionReg.releaseSession(clientAddress, sessionId);
                    }
                    finally {
                        PCEPSessionNegotiator.this.channel.close();
                    }
                }

                @Override
                public Short getSessionId() {
                    return sessionId;
                }
            });
            this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> PCEPSessionNegotiator.lambda$startNegotiation$0((Object)((Object)lock), sessionReg, clientAddress, arg_0)));
            LOG.info("Replacing bootstrap negotiator for channel {}", (Object)this.channel);
            this.channel.pipeline().replace((ChannelHandler)this, "negotiator", (ChannelHandler)n);
            n.startNegotiation();
        }
    }

    @Override
    protected void handleMessage(Message msg) {
        throw new IllegalStateException("Bootstrap negotiator should have been replaced");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$startNegotiation$0(Object lock, PCEPPeerRegistry sessionReg, byte[] clientAddress, ChannelFuture future) throws Exception {
        Object object = lock;
        synchronized (object) {
            sessionReg.removeSessionReference(clientAddress);
        }
    }
}

