/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl.tls;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.opendaylight.protocol.pcep.impl.tls.SslKeyStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContextFactory {
    private static final String PROTOCOL = "TLS";
    private final Tls tlsConfig;
    private static final Logger LOG = LoggerFactory.getLogger(SslContextFactory.class);

    public SslContextFactory(Tls tlsConfig) {
        this.tlsConfig = Objects.requireNonNull(tlsConfig);
    }

    public SSLContext getServerContext() {
        try {
            KeyStore ks = KeyStore.getInstance(this.tlsConfig.getKeystoreType().name());
            ks.load(SslKeyStore.asInputStream(this.tlsConfig.getKeystore(), this.tlsConfig.getKeystorePathType()), this.tlsConfig.getKeystorePassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, this.tlsConfig.getCertificatePassword().toCharArray());
            KeyStore ts = KeyStore.getInstance(this.tlsConfig.getTruststoreType().name());
            ts.load(SslKeyStore.asInputStream(this.tlsConfig.getTruststore(), this.tlsConfig.getTruststorePathType()), this.tlsConfig.getTruststorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            SSLContext serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return serverContext;
        }
        catch (IOException | KeyStoreException e) {
            LOG.warn("IOException - Failed to load keystore / truststore. Failed to initialize the server-side SSLContext", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("NoSuchAlgorithmException - Unsupported algorithm. Failed to initialize the server-side SSLContext", (Throwable)e);
        }
        catch (CertificateException e) {
            LOG.warn("CertificateException - Unable to get a certificate (check password) to set the server-side SSLContext", (Throwable)e);
        }
        catch (NullPointerException | KeyManagementException | UnrecoverableKeyException e) {
            LOG.warn("Exception - Failed to initialize the server-side SSLContext", (Throwable)e);
        }
        return null;
    }
}

