/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactoryDependencies;
import org.opendaylight.protocol.pcep.PCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;

public final class DefaultPCEPSessionNegotiatorFactory
extends AbstractPCEPSessionNegotiatorFactory {
    private final PCEPSessionProposalFactory spf;
    private final int maxUnknownMessages;
    private final Tls tlsConfiguration;

    public DefaultPCEPSessionNegotiatorFactory(PCEPSessionProposalFactory spf, int maxUnknownMessages) {
        this(spf, maxUnknownMessages, null);
    }

    private DefaultPCEPSessionNegotiatorFactory(PCEPSessionProposalFactory spf, int maxUnknownMessages, Tls tlsConfiguration) {
        this.spf = Objects.requireNonNull(spf);
        this.maxUnknownMessages = maxUnknownMessages;
        this.tlsConfiguration = tlsConfiguration;
    }

    public DefaultPCEPSessionNegotiatorFactory(PCEPSessionProposalFactory spf, PcepDispatcherConfig config) {
        this(spf, config.getMaxUnknownMessages().toJava(), config.getTls());
    }

    @Override
    protected AbstractPCEPSessionNegotiator createNegotiator(PCEPSessionNegotiatorFactoryDependencies sessionNegotiatorDependencies, Promise<PCEPSessionImpl> promise, Channel channel, short sessionId) {
        Open proposal = this.spf.getSessionProposal((InetSocketAddress)channel.remoteAddress(), (int)sessionId, sessionNegotiatorDependencies.getPeerProposal());
        return new DefaultPCEPSessionNegotiator(promise, channel, sessionNegotiatorDependencies.getListenerFactory().getSessionListener(), sessionId, this.maxUnknownMessages, proposal, this.tlsConfiguration);
    }

    public PCEPSessionProposalFactory getPCEPSessionProposalFactory() {
        return this.spf;
    }
}

